/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import de.bsvrz.buv.plugin.darstellung.commands.DeleteDoModelCommand;
import de.bsvrz.buv.plugin.darstellung.commands.RemoveDoTypFromAutoEbeneCommand;
import de.bsvrz.buv.plugin.darstellung.model.AutoEbene;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class DeleteEbeneCommand
extends CompoundCommand {
    private final Ebene ebene;
    private final EObject parent;

    public DeleteEbeneCommand(Ebene ebene) {
        Assert.isNotNull((Object)ebene, (String)"ebene");
        this.ebene = ebene;
        this.parent = ebene.eContainer();
        Assert.isNotNull((Object)this.parent, (String)"darstellung/ebene");
        this.setLabel("Ebene l\u00f6schen");
    }

    public boolean canExecute() {
        if (this.parent instanceof Ebene) {
            return ((Ebene)this.parent).getEbenen().size() > 0;
        }
        if (this.parent instanceof Darstellung) {
            return ((Darstellung)this.parent).getEbenen().size() > 1;
        }
        return false;
    }

    public void execute() {
        Assert.isTrue((boolean)this.canExecute(), (String)"command is not executable");
        for (DoModel model : this.ebene.getDoObjekte()) {
            this.add(new DeleteDoModelCommand(model));
        }
        Ebene ebene = this.ebene;
        if (ebene instanceof AutoEbene) {
            AutoEbene autoEbene = (AutoEbene)ebene;
            for (DoTyp doTyp : autoEbene.getDoTypen()) {
                this.add(new RemoveDoTypFromAutoEbeneCommand(doTyp, autoEbene));
            }
        }
        this.add(new InternalDeleteEbeneCommand());
        super.execute();
    }

    private class InternalDeleteEbeneCommand
    extends Command {
        private int index;

        private InternalDeleteEbeneCommand() {
        }

        public void execute() {
            if (DeleteEbeneCommand.this.parent instanceof Ebene) {
                this.index = ((Ebene)DeleteEbeneCommand.this.parent).getEbenen().indexOf((Object)DeleteEbeneCommand.this.ebene);
            } else if (DeleteEbeneCommand.this.parent instanceof Darstellung) {
                this.index = ((Darstellung)DeleteEbeneCommand.this.parent).getEbenen().indexOf((Object)DeleteEbeneCommand.this.ebene);
            }
            this.redo();
        }

        public void redo() {
            if (DeleteEbeneCommand.this.parent instanceof Ebene) {
                ((Ebene)DeleteEbeneCommand.this.parent).getEbenen().remove(this.index);
            } else if (DeleteEbeneCommand.this.parent instanceof Darstellung) {
                ((Darstellung)DeleteEbeneCommand.this.parent).getEbenen().remove(this.index);
            }
        }

        public void undo() {
            if (DeleteEbeneCommand.this.parent instanceof Ebene) {
                ((Ebene)DeleteEbeneCommand.this.parent).getEbenen().add(this.index, (Object)DeleteEbeneCommand.this.ebene);
            } else if (DeleteEbeneCommand.this.parent instanceof Darstellung) {
                ((Darstellung)DeleteEbeneCommand.this.parent).getEbenen().add(this.index, (Object)DeleteEbeneCommand.this.ebene);
            }
        }
    }
}

