/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import de.bsvrz.buv.plugin.darstellung.model.AutoEbene;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungAdapter;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;

public class EnableAutoVerwaltungCommand
extends Command {
    private final DoModel model;
    private final AutoEbene ebene;
    private Darstellung darstellung;

    public EnableAutoVerwaltungCommand(DoModel model, AutoEbene ebene) {
        Assert.isNotNull((Object)model, (String)"model");
        Assert.isNotNull((Object)ebene, (String)"ebene");
        this.model = model;
        this.ebene = ebene;
        this.setLabel("Automatische Verwaltung einschalten");
    }

    public void execute() {
        Assert.isTrue((boolean)this.canExecute(), (String)"command is not executable");
        this.darstellung = DarstellungAdapter.getDarstellung((EObject)this.ebene);
        Assert.isNotNull((Object)this.darstellung, (String)"darstellung");
        Assert.isLegal((boolean)(this.darstellung instanceof MassstaeblicheDarstellung), (String)"Darstellung muss eine ma\u00dfst\u00e4blich Darstellung sein");
        this.redo();
    }

    public boolean canExecute() {
        return !this.ebene.isAutomatischVerwaltet(this.model);
    }

    public void undo() {
        this.ebene.getDoObjekte().add((Object)this.model);
        this.ebene.getSystemObjectsExcludes().add((Object)this.model.getSystemObject());
    }

    public void redo() {
        this.ebene.getDoObjekte().remove((Object)this.model);
        this.ebene.getSystemObjectsExcludes().remove((Object)this.model.getSystemObject());
    }
}

