/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;

public class MoveDoModelCommand
extends Command {
    private final DoModel model;
    private final Point location;
    private Point oldLocation;

    public MoveDoModelCommand(DoModel model, Point location) {
        Assert.isNotNull((Object)model, (String)"model");
        Assert.isNotNull((Object)location, (String)"location");
        this.model = model;
        this.location = location;
        this.setLabel("Darstellungsobjekt verschieben");
    }

    public boolean canExecute() {
        return this.model.eContainer() instanceof Ebene;
    }

    public void execute() {
        Assert.isTrue((boolean)this.canExecute(), (String)"command is not executable");
        this.oldLocation = this.model.getLocation();
        this.redo();
    }

    public void redo() {
        Point newLocation = this.isRelativPositioniert() ? this.getRelativeLocation() : this.getAbsoluteLocation();
        this.model.setLocation(newLocation);
    }

    private boolean isRelativPositioniert() {
        return this.model.getRelativZu() != null;
    }

    private Point getRelativeLocation() {
        return this.getAbsoluteLocation().getCopy().translate(this.model.getRelativZu().getAbsoluteLocation().getNegated());
    }

    private Point getAbsoluteLocation() {
        return this.location;
    }

    public void undo() {
        this.model.setLocation(this.oldLocation);
    }
}

