/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.decorator;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungValidator;
import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class EmfEinstellungenDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private final ImageDescriptor errorImageDescriptor = DObjPlugin.getDefault().getImageDescriptor("icons/error.gif");
    private final ImageDescriptor warningImageDescriptor = DObjPlugin.getDefault().getImageDescriptor("icons/warning.gif");
    private Color errorColor;

    public EmfEinstellungenDecorator() {
        Assert.isNotNull((Object)this.errorImageDescriptor);
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(() -> {
            this.errorColor = display.getSystemColor(15);
            Assert.isNotNull((Object)this.errorColor);
        });
    }

    public void decorate(Object element, IDecoration decoration) {
        if (!(element instanceof Named)) {
            return;
        }
        List<IStatus> status = DarstellungValidator.validiere((Named)element);
        if (status.isEmpty() || !status.stream().filter(s -> !Status.OK_STATUS.equals(s)).findAny().isPresent()) {
            return;
        }
        if (status.stream().filter(s -> s.getSeverity() == 4).findAny().isPresent()) {
            decoration.addSuffix(" (Fehler beim Lesen)");
            decoration.addOverlay(this.errorImageDescriptor, 2);
            decoration.setForegroundColor(this.errorColor);
        } else if (status.stream().filter(s -> s.getSeverity() == 2).findAny().isPresent()) {
            decoration.addSuffix(" (Warnung beim Lesen)");
            decoration.addOverlay(this.warningImageDescriptor, 2);
        }
    }
}

