/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.dialogs;

import com.bitctrl.lib.eclipse.emf.util.EmfUtil;
import com.bitctrl.lib.eclipse.emf.viewers.EmfLabelProvider;
import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung;
import de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung;
import de.bsvrz.buv.plugin.darstellung.util.AnsichtenEinstellungen;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungenEinstellungen;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.basislib.einstellungen.UrlasserDialogAbgebrochenException;
import de.bsvrz.buv.rw.bitctrl.eclipse.viewers.EinstellungenContentProvider;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.progress.UIJob;

public class AnsichtenDialog
extends TitleAreaDialog {
    private TreeViewer viewer;
    private final Set<ITreeSelection> changed = new HashSet<ITreeSelection>();

    public AnsichtenDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(1232);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Ansichten");
        this.setMessage("In diesen Dialog k\u00f6nnen Sie global Aktionen f\u00fcr alle Ansichten ausf\u00fchren.");
        Composite container = (Composite)super.createDialogArea(parent);
        this.viewer = new TreeViewer(container, 65540);
        this.viewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.viewer.setContentProvider((IContentProvider)new EinstellungenContentProvider());
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        this.createAnsichtColumn();
        this.createDarstellungColumn();
        this.createAusschnittColumn();
        this.viewer.setInput((Object)AnsichtenEinstellungen.INSTANCE);
        Composite extraButtons = new Composite(container, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)extraButtons);
        GridLayoutFactory.swtDefaults().applyTo(extraButtons);
        Button removeAusschnittButton = new Button(extraButtons, 8);
        GridDataFactory.swtDefaults().applyTo((Control)removeAusschnittButton);
        removeAusschnittButton.setText("Ausschnitt entfernen");
        removeAusschnittButton.setEnabled(false);
        removeAusschnittButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selected = ((IStructuredSelection)AnsichtenDialog.this.viewer.getSelection()).getFirstElement();
                if (selected instanceof Ansicht) {
                    ((Ansicht)selected).setAusschnitt(null);
                    AnsichtenDialog.this.viewer.update(selected, null);
                    AnsichtenDialog.this.changed.add((ITreeSelection)AnsichtenDialog.this.viewer.getSelection());
                }
            }
        });
        this.viewer.addSelectionChangedListener(event -> {
            Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (selected instanceof Ansicht) {
                removeAusschnittButton.setEnabled(((Ansicht)selected).getAusschnitt() != null);
            } else {
                removeAusschnittButton.setEnabled(false);
            }
        });
        return container;
    }

    private void createAnsichtColumn() {
        TreeViewerColumn column = new TreeViewerColumn(this.viewer, 0);
        column.getColumn().setText("Ansicht");
        column.getColumn().setWidth(200);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof EObject) {
                    return EmfUtil.getText((EObject)((EObject)element));
                }
                return super.getText(element);
            }
        });
    }

    private void createDarstellungColumn() {
        TreeViewerColumn column = new TreeViewerColumn(this.viewer, 0);
        column.getColumn().setText("Darstellung");
        column.getColumn().setWidth(200);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Ansicht) {
                    Ansicht ansicht = (Ansicht)element;
                    return EmfUtil.getText((EObject)ansicht.getDarstellung());
                }
                return "";
            }
        });
        column.setEditingSupport(new EditingSupport((ColumnViewer)this.viewer){

            protected void setValue(Object element, Object value) {
                if (value instanceof Darstellung) {
                    Darstellung newDarst;
                    Ansicht ansicht = (Ansicht)element;
                    Darstellung prevDarst = ansicht.getDarstellung();
                    if (AnsichtenDialog.this.checkReplacement(prevDarst, newDarst = (Darstellung)value)) {
                        ansicht.setDarstellung(newDarst);
                    }
                    this.getViewer().refresh(element);
                }
            }

            protected Object getValue(Object element) {
                Ansicht ansicht = (Ansicht)element;
                return ansicht.getDarstellung();
            }

            protected CellEditor getCellEditor(Object element) {
                return new DialogCellEditor((Composite)AnsichtenDialog.this.viewer.getTree()){

                    protected Object openDialogBox(Control cellEditorWindow) {
                        ElementTreeSelectionDialog dlg = new ElementTreeSelectionDialog(AnsichtenDialog.this.getShell(), (ILabelProvider)new EmfLabelProvider(), (ITreeContentProvider)new EinstellungenContentProvider());
                        dlg.setAllowMultiple(false);
                        dlg.setValidator(selection -> {
                            Object[] objectArray = selection;
                            int n = selection.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object e = objectArray[n2];
                                if (!(e instanceof Darstellung)) {
                                    return new Status(2, "de.bsvrz.buv.plugin.dobj", "Das ausgew\u00e4hlte Objekt ist keine Darstellung.");
                                }
                                ++n2;
                            }
                            return Status.OK_STATUS;
                        });
                        dlg.setInput((Object)DarstellungenEinstellungen.INSTANCE);
                        if (dlg.open() == 0) {
                            (this).AnsichtenDialog.this.changed.add((ITreeSelection)this.getViewer().getSelection());
                            return dlg.getFirstResult();
                        }
                        return null;
                    }

                    protected void updateContents(Object value) {
                        if (this.getDefaultLabel() == null) {
                            return;
                        }
                        this.getDefaultLabel().setText(EmfUtil.getText((EObject)((EObject)value)));
                    }
                };
            }

            protected boolean canEdit(Object element) {
                return element instanceof Ansicht;
            }
        });
    }

    private void createAusschnittColumn() {
        TreeViewerColumn column = new TreeViewerColumn(this.viewer, 0);
        column.getColumn().setText("Ausschnitt");
        column.getColumn().setWidth(200);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Ansicht) {
                    Ansicht ansicht = (Ansicht)element;
                    return EmfUtil.getText((EObject)ansicht.getAusschnitt());
                }
                return "";
            }
        });
    }

    protected void okPressed() {
        UIJob job = new UIJob("Ansichten speichern"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                monitor.beginTask("Ansichten speichern", AnsichtenDialog.this.changed.size());
                for (ITreeSelection s : AnsichtenDialog.this.changed) {
                    SpeicherKey art = (SpeicherKey)s.getPaths()[0].getFirstSegment();
                    Ansicht ansicht = (Ansicht)s.getPaths()[0].getLastSegment();
                    try {
                        AnsichtenEinstellungen.INSTANCE.setModellEinstellungen(art, ansicht.getName(), ansicht);
                    }
                    catch (UrlasserDialogAbgebrochenException urlasserDialogAbgebrochenException) {
                    }
                    catch (IOException ex) {
                        ErrorDialog.openError((Shell)AnsichtenDialog.this.getShell(), (String)"FEHLER", (String)"Ansichten konnten nicht gespeichert werden!", (IStatus)new Status(4, "de.bsvrz.buv.plugin.dobj", ex.getLocalizedMessage(), (Throwable)ex));
                    }
                    monitor.worked(1);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        super.okPressed();
    }

    private boolean checkReplacement(Darstellung prevDarst, Darstellung newDarst) {
        boolean result = true;
        if (prevDarst instanceof MassstaeblicheDarstellung && newDarst instanceof StilisierteDarstellung) {
            result = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Darstellung ersetzen", (String)"Soll die ma\u00dfst\u00e4bliche Darstellung tats\u00e4chlich durch eine stilisierte Darstellung ersetzt werden?");
        }
        if (result && prevDarst instanceof StilisierteDarstellung && newDarst instanceof MassstaeblicheDarstellung) {
            result = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Darstellung ersetzen", (String)"Soll die stilisierte Darstellung tats\u00e4chlich durch eine ma\u00dfst\u00e4bliche Darstellung ersetzt werden?");
        }
        if (result && prevDarst instanceof MassstaeblicheDarstellung && newDarst instanceof MassstaeblicheDarstellung) {
            double prevMinL = ((MassstaeblicheDarstellung)prevDarst).getMinimaleGeographischeLaenge();
            double prevMinB = ((MassstaeblicheDarstellung)prevDarst).getMinimaleGeographischeBreite();
            double prevMaxL = ((MassstaeblicheDarstellung)prevDarst).getMaximaleGeographischeLaenge();
            double prevMaxB = ((MassstaeblicheDarstellung)prevDarst).getMaximaleGeographischeBreite();
            double newMinL = ((MassstaeblicheDarstellung)newDarst).getMinimaleGeographischeLaenge();
            double newMinB = ((MassstaeblicheDarstellung)newDarst).getMinimaleGeographischeBreite();
            double newMaxL = ((MassstaeblicheDarstellung)newDarst).getMaximaleGeographischeLaenge();
            double newMaxB = ((MassstaeblicheDarstellung)newDarst).getMaximaleGeographischeBreite();
            if (prevMinL != newMinL || prevMaxL != newMaxL || prevMinB != newMinB || prevMaxB != newMaxB) {
                result = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Darstellung ersetzen", (String)("Koordinaten der Darstellungen stimmen nicht \u00fcberein!\n\nBisherige Koordinaten:\n  Minimale L\u00e4nge: " + prevMinL + "\n  Minimale Breite: " + prevMinB + "\n  Maxmiale L\u00e4nge: " + prevMaxL + "\n  Maximale Breite: " + prevMaxB + "\nNeue Koordinaten:\n  Minimale L\u00e4nge: " + newMinL + "\n  Minimale Breite: " + newMinB + "\n  Maximale L\u00e4nge: " + newMaxL + "\n  Maximale Breite: " + newMaxB + "\n\nSoll die Darstellung trotzdem ersetzt werden?"));
            }
        }
        return result;
    }
}

