/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.dialogs;

import com.bitctrl.lib.eclipse.dialogs.ToolWindow;
import com.bitctrl.lib.eclipse.emf.gef.commands.MoveCommand;
import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import de.bsvrz.buv.plugin.darstellung.dialogs.ViewerTransfer;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class EbenenWindow
extends ToolWindow {
    private CheckboxTreeViewer viewer;
    private Image ebeneVisible;
    private Image ebeneInvisible;

    public EbenenWindow(IWorkbenchPart part, Control partControl) {
        super(part, partControl);
        this.setShellStyle(2164);
        this.setCorner(ToolWindow.Corner.TopRight);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        if (this.getDarstellung() != null) {
            this.createViewer(container);
        } else {
            Label label = new Label(container, 64);
            label.setText("Keine Darstellung vorhanden.");
            label.setBackground(parent.getDisplay().getSystemColor(1));
        }
        return container;
    }

    private void createViewer(Composite parent) {
        this.ebeneVisible = DarstellungIcons.StatusEbeneVisible.getImageDescriptor().createImage();
        this.ebeneInvisible = DarstellungIcons.StatusEbeneInvisible.getImageDescriptor().createImage();
        this.viewer = new CheckboxTreeViewer(parent, 2052);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProviderExtension());
        this.viewer.setContentProvider((IContentProvider)new EbenenTreeContentProvider());
        this.viewer.setCheckStateProvider((ICheckStateProvider)new CheckStateProvider());
        this.viewer.setInput(this.getDarstellung().getEbenen());
        Transfer[] transferTypes = new Transfer[]{ViewerTransfer.getInstance()};
        int operations = 3;
        this.viewer.addDragSupport(3, transferTypes, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)EbenenWindow.this.viewer.getSelection();
                Object firstElement = selection.getFirstElement();
                if (ViewerTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = firstElement;
                }
            }
        });
        this.viewer.addDropSupport(3, transferTypes, (DropTargetListener)new EbenenViewerDropAdapter((Viewer)this.viewer));
        this.viewer.addCheckStateListener((ICheckStateListener)new CheckStateListener());
    }

    private Darstellung getDarstellung() {
        Darstellung result = (Darstellung)this.getWorkbenchPart().getAdapter(Darstellung.class);
        if (result == null) {
            result = (Darstellung)Platform.getAdapterManager().getAdapter((Object)this.getWorkbenchPart(), Darstellung.class);
        }
        return result;
    }

    private CommandStack getCommandStack() {
        CommandStack result = (CommandStack)this.getWorkbenchPart().getAdapter(CommandStack.class);
        if (result == null) {
            result = (CommandStack)Platform.getAdapterManager().getAdapter((Object)this.getWorkbenchPart(), CommandStack.class);
        }
        return result;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Ebenen");
        newShell.setSize(200, 400);
    }

    public boolean close() {
        if (this.ebeneVisible != null) {
            this.ebeneVisible.dispose();
            this.ebeneVisible = null;
        }
        if (this.ebeneInvisible != null) {
            this.ebeneInvisible.dispose();
            this.ebeneInvisible = null;
        }
        return super.close();
    }

    private final class CheckStateListener
    implements ICheckStateListener {
        private CheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Ebene ebene = (Ebene)event.getElement();
            if (!ebene.isAusblendbar()) {
                event.getCheckable().setChecked((Object)ebene, true);
                SetCommand cmd = new SetCommand((EObject)ebene, (EStructuralFeature)DarstellungPackage.Literals.EBENE__VISIBLE, (Object)true);
                EbenenWindow.this.getCommandStack().execute((Command)cmd);
            } else {
                SetCommand cmd = new SetCommand((EObject)ebene, (EStructuralFeature)DarstellungPackage.Literals.EBENE__VISIBLE, (Object)(!ebene.isVisible() ? 1 : 0));
                EbenenWindow.this.getCommandStack().execute((Command)cmd);
            }
            EbenenWindow.this.viewer.refresh();
        }
    }

    private static final class CheckStateProvider
    implements ICheckStateProvider {
        private CheckStateProvider() {
        }

        public boolean isGrayed(Object element) {
            if (element instanceof Ebene) {
                return !((Ebene)element).isAusblendbar();
            }
            return false;
        }

        public boolean isChecked(Object element) {
            if (element instanceof Ebene) {
                return ((Ebene)element).isVisible();
            }
            return false;
        }
    }

    private static final class EbenenTreeContentProvider
    implements ITreeContentProvider {
        private EbenenTreeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList list = new ArrayList((List)inputElement);
            Collections.reverse(list);
            return list.toArray();
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Ebene) {
                return ((Ebene)parentElement).getEbenen().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof Ebene) {
                return ((Ebene)element).eContainer();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Ebene) {
                return !((Ebene)element).getEbenen().isEmpty();
            }
            return false;
        }
    }

    private final class EbenenViewerDropAdapter
    extends ViewerDropAdapter {
        private EbenenViewerDropAdapter(Viewer viewer) {
            super(viewer);
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            IStructuredSelection isel = (IStructuredSelection)this.getViewer().getSelection();
            Object[] objectArray = isel.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof Ebene && target instanceof Ebene && !Objects.equals(((Ebene)obj).eContainer(), ((Ebene)target).eContainer())) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public boolean performDrop(Object data) {
            Ebene ebene = (Ebene)data;
            DropTargetEvent event = this.getCurrentEvent();
            int location = this.determineLocation(event);
            Ebene target = (Ebene)this.determineTarget(event);
            EReference feature = DarstellungPackage.Literals.DARSTELLUNG__EBENEN;
            EObject parent = target.eContainer();
            EList<Ebene> ebenen = EbenenWindow.this.getDarstellung().getEbenen();
            int targetIndex = ebenen.indexOf((Object)target);
            if (parent instanceof Ebene) {
                ebenen = ((Ebene)parent).getEbenen();
                targetIndex = ebenen.indexOf((Object)target);
                feature = DarstellungPackage.Literals.EBENE__EBENEN;
            }
            MoveCommand cmd = switch (location) {
                case 1 -> {
                    if (targetIndex > 0) {
                        --targetIndex;
                    }
                    yield new MoveCommand(parent, (EStructuralFeature)feature, (Object)ebene, targetIndex);
                }
                case 2 -> {
                    if (targetIndex < ebenen.size() - 1) {
                        ++targetIndex;
                    }
                    yield new MoveCommand(parent, (EStructuralFeature)feature, (Object)ebene, targetIndex);
                }
                case 3 -> new MoveCommand(parent, (EStructuralFeature)feature, (Object)ebene, targetIndex);
                default -> null;
            };
            if (cmd != null) {
                EbenenWindow.this.getCommandStack().execute((Command)cmd);
                this.getViewer().refresh();
            }
            return true;
        }
    }

    private static final class LabelProviderExtension
    extends LabelProvider
    implements IColorProvider {
        private LabelProviderExtension() {
        }

        public String getText(Object element) {
            return ((Ebene)element).getName();
        }

        public Color getForeground(Object element) {
            Ebene ebene = (Ebene)element;
            if (ebene.isVisible()) {
                return ColorConstants.black;
            }
            return ColorConstants.gray;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

