/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.editparts;

import de.bsvrz.buv.plugin.darstellung.editparts.EbeneEditPart;
import de.bsvrz.buv.plugin.darstellung.model.AutoEbene;
import de.bsvrz.buv.plugin.dobj.requests.OnlineRequest;
import de.bsvrz.buv.plugin.dobj.tools.DObjSelectionTool;
import de.bsvrz.dav.daf.main.config.MutableSet;
import de.bsvrz.dav.daf.main.config.MutableSetChangeListener;
import de.bsvrz.dav.daf.main.config.SystemObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;

public class AutoEbeneEditPart
extends EbeneEditPart
implements MutableSetChangeListener {
    private boolean online;
    private boolean pretendToBeEmpty;

    public AutoEbene getModel() {
        return (AutoEbene)super.getModel();
    }

    @Override
    protected List<?> getModelChildren() {
        ArrayList<Object> doModels = new ArrayList<Object>();
        if (!this.pretendToBeEmpty) {
            doModels.addAll(super.getModelChildren());
            doModels.addAll((Collection<Object>)this.getModel().getAutoDoObjekte());
        }
        return doModels;
    }

    public boolean isOnline() {
        return this.online;
    }

    protected void geheOnline() {
        if (this.isOnline()) {
            return;
        }
        for (MutableSet set : this.getModel().getMutableSets()) {
            set.addChangeListener((MutableSetChangeListener)this);
        }
    }

    protected void geheOffline() {
        if (!this.isOnline()) {
            return;
        }
        for (MutableSet set : this.getModel().getMutableSets()) {
            set.removeChangeListener((MutableSetChangeListener)this);
        }
    }

    @Override
    public void deactivate() {
        this.geheOffline();
        super.deactivate();
    }

    @Override
    public void performRequest(Request req) {
        super.performRequest(req);
        if ("Online".equals(req.getType())) {
            if (((OnlineRequest)req).isOnline()) {
                this.geheOnline();
                this.online = true;
            } else {
                this.geheOffline();
                this.online = false;
            }
        }
    }

    @Override
    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        Object notifier = notification.getNotifier();
        int type = notification.getEventType();
        if (notifier instanceof AutoEbene) {
            int featureID = notification.getFeatureID(AutoEbene.class);
            switch (type) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    switch (featureID) {
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 16: 
                        case 17: {
                            this.refreshChildren();
                        }
                    }
                }
            }
        }
    }

    public void update(MutableSet set, SystemObject[] addedObjects, SystemObject[] removedObjects) {
        if (this.getViewer().getControl() != null && !this.getViewer().getControl().isDisposed()) {
            this.getViewer().getControl().getDisplay().asyncExec(() -> {
                DObjSelectionTool tool;
                this.pretendToBeEmpty = true;
                this.refreshChildren();
                this.pretendToBeEmpty = false;
                this.refreshChildren();
                EditPartViewer viewer = this.getViewer();
                if (viewer != null && (tool = (DObjSelectionTool)((Object)((Object)viewer.getProperty(DObjSelectionTool.class.getSimpleName())))) != null) {
                    tool.resetChildren();
                }
                if (this.isOnline()) {
                    for (Object child : this.getChildren()) {
                        ((EditPart)child).performRequest((Request)new OnlineRequest(true));
                    }
                }
            });
        }
    }
}

