/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.editparts.tree;

import com.bitctrl.lib.eclipse.emf.gef.editparts.tree.EListNodeTreeEditPart;
import com.bitctrl.lib.eclipse.emf.gef.model.EListNode;
import de.bsvrz.buv.plugin.darstellung.editparts.tree.AnsichtTreeEditPart;
import de.bsvrz.buv.plugin.darstellung.editparts.tree.AusschnittTreeEditPart;
import de.bsvrz.buv.plugin.darstellung.editparts.tree.DarstellungTreeEditPart;
import de.bsvrz.buv.plugin.darstellung.editparts.tree.DarstellungsSpalteTreeEditPart;
import de.bsvrz.buv.plugin.darstellung.editparts.tree.DoModelTreeEditPart;
import de.bsvrz.buv.plugin.darstellung.editparts.tree.DoTypTreeEditPart;
import de.bsvrz.buv.plugin.darstellung.editparts.tree.EbeneTreeEditPart;
import de.bsvrz.buv.plugin.darstellung.editparts.tree.SystemObjectTreeEditPart;
import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.Ausschnitt;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungIcons;
import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.dav.daf.main.config.SystemObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class DarstellungTreeEditPartFactory
implements EditPartFactory {
    public EditPart createEditPart(EditPart context, Object model) {
        EditPart editPart = this.getEditPart(model);
        editPart.setModel(model);
        return editPart;
    }

    private EditPart getEditPart(Object model) {
        if (model instanceof Ansicht) {
            return new AnsichtTreeEditPart();
        }
        if (model instanceof Ausschnitt) {
            return new AusschnittTreeEditPart();
        }
        if (model instanceof Darstellung) {
            return new DarstellungTreeEditPart();
        }
        if (model instanceof Ebene) {
            return new EbeneTreeEditPart();
        }
        if (model instanceof DarstellungsSpalte) {
            return new DarstellungsSpalteTreeEditPart();
        }
        if (model instanceof DoTyp) {
            return new DoTypTreeEditPart();
        }
        if (model instanceof EListNode) {
            return new DarstellungEListNodeTreeEditPart();
        }
        if (model instanceof DoModel) {
            return new DoModelTreeEditPart();
        }
        if (model instanceof SystemObject) {
            return new SystemObjectTreeEditPart();
        }
        Object msg = "Kann kein EditPart f\u00fcr das Modellobjekt erzeugen: ";
        msg = (String)msg + String.valueOf(model != null ? model.getClass() : "null");
        DObjPlugin.getDefault().getLog().error((String)msg);
        throw new IllegalArgumentException((String)msg);
    }

    private static final class DarstellungEListNodeTreeEditPart
    extends EListNodeTreeEditPart {
        private DarstellungEListNodeTreeEditPart() {
        }

        protected Image getImage() {
            int featureID = this.getModel().getFeature().getFeatureID();
            ImageRegistry imageRegistry = DObjPlugin.getDefault().getImageRegistry();
            if (featureID == 9 || featureID == 3) {
                Image result = imageRegistry.get(DarstellungIcons.Ebene.name());
                if (result == null) {
                    imageRegistry.put(DarstellungIcons.Ebene.name(), DarstellungIcons.Ebene.getImageDescriptor());
                    result = imageRegistry.get(DarstellungIcons.Ebene.name());
                }
                return result;
            }
            if (featureID == 16) {
                Image result = imageRegistry.get(DarstellungIcons.DarstellungsSpalte.name());
                if (result == null) {
                    imageRegistry.put(DarstellungIcons.DarstellungsSpalte.name(), DarstellungIcons.DarstellungsSpalte.getImageDescriptor());
                    result = imageRegistry.get(DarstellungIcons.DarstellungsSpalte.name());
                }
                return result;
            }
            if (featureID == 7 || featureID == 2) {
                Image result = imageRegistry.get(DarstellungIcons.DarstellungsObjektTyp.name());
                if (result == null) {
                    imageRegistry.put(DarstellungIcons.DarstellungsObjektTyp.name(), DarstellungIcons.DarstellungsObjektTyp.getImageDescriptor());
                    result = imageRegistry.get(DarstellungIcons.DarstellungsObjektTyp.name());
                }
                return result;
            }
            return super.getImage();
        }

        protected String getText() {
            int featureID = this.getModel().getFeature().getFeatureID();
            if (featureID == 9 || featureID == 3) {
                return "Ebenen";
            }
            if (featureID == 16) {
                return "Spalten";
            }
            if (featureID == 7) {
                return "DoTypen der Ebene";
            }
            return super.getText();
        }
    }
}

