/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.editpolicies;

import com.bitctrl.lib.eclipse.emf.gef.model.Sized;
import de.bsvrz.buv.plugin.darstellung.commands.MoveDoModelCommand;
import de.bsvrz.buv.plugin.darstellung.commands.ResizeDoModelCommand;
import de.bsvrz.buv.plugin.dobj.HotspotConverter;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ConstrainedLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class AnsichtLayoutEditPolicy
extends ConstrainedLayoutEditPolicy {
    private static final Dimension PREFERRED_SIZE = new Dimension(-1, -1);

    public EditPart getTargetEditPart(Request request) {
        return this.getHost();
    }

    protected Command createAddCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        if (child.getModel() instanceof DoModel && constraint instanceof Rectangle) {
            DoModel model = (DoModel)child.getModel();
            Rectangle bounds = (Rectangle)constraint;
            Point location = this.getHotspotLocation(child, bounds);
            CompoundCommand command = new CompoundCommand("Darstellungsobjekt Verschieben und Skalieren");
            command.add((Command)new MoveDoModelCommand(model, location));
            if (model instanceof Sized) {
                command.add((Command)new ResizeDoModelCommand(model, bounds.getSize()));
            }
            return command.unwrap();
        }
        return null;
    }

    private Point getHotspotLocation(EditPart child, Rectangle bounds) {
        HotspotConverter hotspotConverter = (HotspotConverter)child.getAdapter(HotspotConverter.class);
        if (hotspotConverter == null) {
            hotspotConverter = (HotspotConverter)Platform.getAdapterManager().getAdapter((Object)child, HotspotConverter.class);
        }
        Point location = hotspotConverter != null ? hotspotConverter.convertViewToModel(bounds.getLocation()) : bounds.getLocation();
        return location;
    }

    public Object getConstraintFor(Point p) {
        return new Rectangle(p, PREFERRED_SIZE);
    }

    public Object getConstraintFor(Rectangle r) {
        return new Rectangle(r);
    }

    protected Command getCreateCommand(CreateRequest request) {
        return null;
    }
}

