/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.editpolicies;

import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class DarstellungRootComponentEditPolicy
extends RootComponentEditPolicy {
    public EditPart getTargetEditPart(Request request) {
        if (request instanceof ChangeBoundsRequest) {
            return this.getTargetEditPart((ChangeBoundsRequest)request);
        }
        if (request instanceof CreateRequest) {
            return this.getTargetEditPart((CreateRequest)request);
        }
        return super.getTargetEditPart(request);
    }

    private EditPart getTargetEditPart(ChangeBoundsRequest request) {
        List editParts = request.getEditParts();
        if (editParts.size() > 0) {
            EditPart editPart = (EditPart)editParts.get(0);
            EditPart parent = editPart.getParent();
            if (parent.getModel() instanceof DarstellungsSpalte) {
                Point location = request.getLocation();
                Ebene ebene = (Ebene)parent.getParent().getModel();
                Darstellung darstellung = DarstellungAdapter.getDarstellung((EObject)ebene);
                StilisierteDarstellung stilisierteDarstellung = (StilisierteDarstellung)darstellung;
                return this.getDarstellungsSpalte(location, stilisierteDarstellung);
            }
            return parent;
        }
        return null;
    }

    private EditPart getDarstellungsSpalte(Point location, StilisierteDarstellung stilisierteDarstellung) {
        int offset = 0;
        for (DarstellungsSpalte spalte : stilisierteDarstellung.getSpalten()) {
            if (location.x >= (offset += spalte.getWidth())) continue;
            EditPart editPart = (EditPart)this.getHost().getViewer().getEditPartRegistry().get(spalte);
            Assert.isNotNull((Object)editPart, (String)"editPart zu Darstellungsspalte nicht gefunden");
            return editPart;
        }
        return null;
    }

    private EditPart getTargetEditPart(CreateRequest request) {
        for (EditPart child : DarstellungRootComponentEditPolicy.getChildren(this.getHost())) {
            StilisierteDarstellung stilisierteDarstellung;
            EditPart childEditPart = child;
            Ebene ebene = (Ebene)childEditPart.getModel();
            if (!ebene.isEditable()) continue;
            Darstellung darstellung = DarstellungAdapter.getDarstellung((EObject)ebene);
            if (darstellung instanceof StilisierteDarstellung && !(stilisierteDarstellung = (StilisierteDarstellung)darstellung).getSpalten().isEmpty()) {
                Point location = this.getConstraintFor(request);
                return this.getDarstellungsSpalte(location, stilisierteDarstellung);
            }
            return childEditPart;
        }
        return null;
    }

    private static List<EditPart> getChildren(EditPart parent) {
        ArrayList<EditPart> result = new ArrayList<EditPart>();
        List children = parent.getChildren().stream().filter(c -> c.getModel() instanceof Ebene).collect(Collectors.toList());
        result.addAll(children);
        result.addAll(children.stream().flatMap(c -> DarstellungRootComponentEditPolicy.getChildren(c).stream()).collect(Collectors.toList()));
        return result;
    }

    private Point getConstraintFor(CreateRequest request) {
        PrecisionPoint location = new PrecisionPoint(request.getLocation());
        this.translateFromAbsoluteToLayoutRelative((Translatable)location);
        return location;
    }

    private void translateFromAbsoluteToLayoutRelative(Translatable t) {
        IFigure figure = this.getLayoutContainer();
        figure.translateToRelative(t);
        figure.translateFromParent(t);
        Point negatedLayoutOrigin = this.getLayoutOrigin().getNegated();
        t.performTranslate(negatedLayoutOrigin.x, negatedLayoutOrigin.y);
    }

    private IFigure getLayoutContainer() {
        return ((GraphicalEditPart)this.getHost()).getContentPane();
    }

    private Point getLayoutOrigin() {
        return this.getLayoutContainer().getClientArea().getLocation();
    }
}

