/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.figures;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class SpaltenLayout
extends AbstractLayout {
    public static final int DEFAULT_SPALTENBREITE = 250;
    private final Map<IFigure, Integer> constraints = new HashMap<IFigure, Integer>();
    private int height;

    public SpaltenLayout() {
        this.setObserveVisibility(true);
    }

    protected int getWidth(IFigure child) {
        Integer width = (Integer)this.getConstraint(child);
        if (width != null) {
            return width;
        }
        return 250;
    }

    public void layout(IFigure container) {
        Point offset = this.getOrigin(container);
        int x = offset.x;
        for (Object e : container.getChildren()) {
            IFigure child = (IFigure)e;
            if (!child.isVisible()) continue;
            int width = this.getWidth(child);
            Rectangle bounds = new Rectangle(x, offset.y, width, this.getHeight());
            x += width;
            child.setBounds(bounds);
        }
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Dimension result = new Dimension(0, this.height);
        for (Object e : container.getChildren()) {
            IFigure child = (IFigure)e;
            if (!child.isVisible()) continue;
            result.width += this.getWidth(child);
        }
        return result;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        if (this.height == height) {
            return;
        }
        this.height = height;
        this.invalidate();
    }

    public Point getOrigin(IFigure parent) {
        return parent.getClientArea().getLocation();
    }

    public Object getConstraint(IFigure child) {
        return this.constraints.get(child);
    }

    public void setConstraint(IFigure child, Object constraint) {
        super.setConstraint(child, constraint);
        if (constraint instanceof Integer) {
            this.constraints.put(child, (Integer)constraint);
        }
    }

    public void remove(IFigure child) {
        super.remove(child);
        this.constraints.remove(child);
    }
}

