/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.search;

import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.search.ObjekteSucheDialog;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenDavObjektSuchenDialog
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object firstResult;
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        GraphicalViewer graphicalViewer = (GraphicalViewer)activePart.getAdapter(GraphicalViewer.class);
        Darstellung darstellung = (Darstellung)activePart.getAdapter(Darstellung.class);
        ZoomManager zoomManager = (ZoomManager)activePart.getAdapter(ZoomManager.class);
        ObjekteSucheDialog d = new ObjekteSucheDialog(shell, graphicalViewer);
        if (d.open() == 0 && (firstResult = d.getFirstResult()) instanceof GraphicalEditPart) {
            GraphicalEditPart editPart = (GraphicalEditPart)firstResult;
            int zoomSuchfunktion = darstellung.getZoomSuchfunktion();
            zoomManager.setZoomAsText(zoomSuchfunktion + "%");
            this.selectObjekt(graphicalViewer, editPart);
        }
        return null;
    }

    private void selectObjekt(GraphicalViewer graphicalViewer, GraphicalEditPart editPart) {
        Control control = graphicalViewer.getControl();
        if (control instanceof FigureCanvas) {
            FigureCanvas canvas = (FigureCanvas)control;
            Viewport port = canvas.getViewport();
            IFigure target = editPart.getFigure();
            Rectangle exposeRegion = target.getBounds().getCopy();
            target = target.getParent();
            while (target != null && target != port) {
                target.translateToParent((Translatable)exposeRegion);
                target = target.getParent();
            }
            Dimension viewportSize = port.getClientArea().getSize();
            exposeRegion.expand(viewportSize.width / 2, viewportSize.height / 2);
            Point topLeft = exposeRegion.getTopLeft();
            Point bottomRight = exposeRegion.getBottomRight().translate(viewportSize.getNegated());
            Point finalLocation = new Point();
            finalLocation.x = viewportSize.width < exposeRegion.width ? Math.min(bottomRight.x, Math.max(topLeft.x, port.getViewLocation().x)) : Math.min(topLeft.x, Math.max(bottomRight.x, port.getViewLocation().x));
            finalLocation.y = viewportSize.height < exposeRegion.height ? Math.min(bottomRight.y, Math.max(topLeft.y, port.getViewLocation().y)) : Math.min(topLeft.y, Math.max(bottomRight.y, port.getViewLocation().y));
            ((FigureCanvas)control).scrollSmoothTo(finalLocation.x, finalLocation.y);
        } else {
            graphicalViewer.reveal((EditPart)editPart);
        }
        if (editPart.isSelectable()) {
            graphicalViewer.setSelection((ISelection)new StructuredSelection((Object)editPart));
        }
    }
}

