/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.util;

import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.rw.basislib.einstellungen.Einstellungen;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungsAdresse;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.EMFModellEinstellungen;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.storage.Named;
import de.bsvrz.puk.param.lib.daten.UrlasserInfo;
import de.bsvrz.sys.funclib.debug.Debug;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EMFIDModellEinstellungen<T extends EObject>
extends EMFModellEinstellungen<T> {
    private static final Debug logger = Debug.getLogger();
    private static final long serialVersionUID = 1L;

    public EMFIDModellEinstellungen(Class<T> type, EClass eClass) {
        super(type, eClass);
    }

    public void setModellEinstellungen(SpeicherKey art, String name, T object) throws IOException {
        this.setModellEinstellungen(art, name, object, (UrlasserInfo)null);
    }

    public void setModellEinstellungen(SpeicherKey art, String name, T object, UrlasserInfo urlasser) throws IOException {
        Einstellungen verwaltung = RahmenwerkService.getService().getEinstellungen();
        super.setModellEinstellungen(art, name, null, urlasser);
        this.delete(art, name, urlasser);
        if (object != null) {
            EinstellungsAdresse adresse = new EinstellungsAdresse(null, this.getTypeClass().getName() + ":" + EcoreUtil.getID(object), art.getOwnerType(), art.getPid(), art.getLocation());
            String param = (String)verwaltung.getValue(adresse);
            List contents = this.getModellEinstellungenInternal(param);
            if (contents != null) {
                boolean hasSet = false;
                for (Named named : contents) {
                    String contentsName = this.getName(named);
                    if (contentsName == null || !contentsName.equals(name)) continue;
                    this.setObject(named, (EObject)object);
                    this.setLastModification(named, new Date());
                    hasSet = true;
                    break;
                }
                if (!hasSet) {
                    Named named;
                    named = this.createStorage();
                    this.setName(named, name);
                    this.setObject(named, (EObject)object);
                    this.setLastModification(named, new Date());
                    contents.add(named);
                }
            }
            param = this.saveModellEinstellungenInternal(contents);
            if (urlasser != null) {
                verwaltung.setValue(adresse, (Object)param, urlasser);
            } else {
                verwaltung.setValue(adresse, (Object)param);
            }
            this.firePropertyChanged("einstellungChanged", null, name);
        }
    }

    private void delete(SpeicherKey art, String name, UrlasserInfo urlasser) throws IOException {
        Einstellungen verwaltung = RahmenwerkService.getService().getEinstellungen();
        Map einstellungsIds = verwaltung.getEinstellungsId(art);
        List ansichtsKeys = einstellungsIds.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(this.getTypeClass().getName())).map(e -> (String)e.getKey()).collect(Collectors.toList());
        for (String key : ansichtsKeys) {
            EinstellungsAdresse adresse = new EinstellungsAdresse(null, key, art.getOwnerType(), art.getPid(), art.getLocation());
            String param = (String)verwaltung.getValue(adresse);
            List contents = this.getModellEinstellungenInternal(param);
            if (contents == null) continue;
            Optional<Named> optional = contents.stream().filter(c -> Objects.equals(this.getName((Named)c), name)).findFirst();
            if (optional.isPresent()) {
                contents.remove(optional.get());
                param = this.saveModellEinstellungenInternal(contents);
                verwaltung.setValue(adresse, (Object)param, urlasser);
                this.firePropertyChanged("einstellungChanged", null, name);
            }
            if (!contents.isEmpty()) continue;
            verwaltung.removeValue(adresse, urlasser);
        }
    }

    protected List<Named> getModellEinstellungenList(SpeicherKey art) {
        Einstellungen einstellungen = RahmenwerkService.getService().getEinstellungen();
        try {
            Map einstellungsIds = einstellungen.getEinstellungsId(art);
            List ansichtsKeys = einstellungsIds.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(this.getTypeClass().getName())).map(e -> (String)e.getKey()).collect(Collectors.toList());
            return ansichtsKeys.stream().map(s -> {
                try {
                    return (String)einstellungen.getValue(new EinstellungsAdresse(null, s, art.getOwnerType(), art.getPid(), art.getLocation()));
                }
                catch (IOException ex) {
                    DObjPlugin.getDefault().getLog().log((IStatus)new Status(2, "de.bsvrz.buv.plugin.dobj", "Lesen der Benutzereinstellungen " + String.valueOf(art) + " - " + s + " ist fehlgeschlagen.", (Throwable)ex));
                    return null;
                }
            }).filter(p -> p != null).flatMap(p -> this.getModellEinstellungenInternal((String)p).stream()).collect(Collectors.toList());
        }
        catch (IOException ex) {
            logger.warning(ex.getLocalizedMessage());
            return Collections.emptyList();
        }
    }

    public T getModellEinstellungbyId(String id) {
        Einstellungen einstellungen = RahmenwerkService.getService().getEinstellungen();
        for (SpeicherKey art : SpeicherKey.getDefaultKeys()) {
            try {
                Map einstellungsIds = einstellungen.getEinstellungsId(art);
                List ansichtsKeys = einstellungsIds.entrySet().stream().filter(e -> Objects.equals(e.getKey(), this.getTypeClass().getName() + ":" + id)).map(e -> (String)e.getKey()).collect(Collectors.toList());
                return (T)((EObject)ansichtsKeys.stream().map(s -> {
                    try {
                        return (String)einstellungen.getValue(new EinstellungsAdresse(null, s, art.getOwnerType(), art.getPid(), art.getLocation()));
                    }
                    catch (IOException ex) {
                        DObjPlugin.getDefault().getLog().log((IStatus)new Status(2, "de.bsvrz.buv.plugin.dobj", "Lesen der Benutzereinstellungen " + String.valueOf(art) + " - " + s + " ist fehlgeschlagen.", (Throwable)ex));
                        return null;
                    }
                }).filter(p -> p != null).flatMap(p -> this.getModellEinstellungenInternal((String)p).stream()).map(n -> n.getObject()).findFirst().orElse(null));
            }
            catch (IOException ex) {
                logger.warning(ex.getLocalizedMessage());
            }
        }
        return null;
    }

    public List<Resource.Diagnostic> getModellEinstellungDiagnostic(String id) {
        if (id == null || id.isEmpty()) {
            return Collections.emptyList();
        }
        Einstellungen einstellungen = RahmenwerkService.getService().getEinstellungen();
        for (SpeicherKey art : SpeicherKey.getDefaultKeys()) {
            try {
                Map einstellungsIds = einstellungen.getEinstellungsId(art);
                List ansichtsKeys = einstellungsIds.entrySet().stream().filter(e -> Objects.equals(e.getKey(), this.getTypeClass().getName() + ":" + id)).map(e -> (String)e.getKey()).collect(Collectors.toList());
                Optional<String> parameter = ansichtsKeys.stream().map(s -> {
                    try {
                        return (String)einstellungen.getValue(new EinstellungsAdresse(null, s, art.getOwnerType(), art.getPid(), art.getLocation()));
                    }
                    catch (IOException ex) {
                        DObjPlugin.getDefault().getLog().log((IStatus)new Status(2, "de.bsvrz.buv.plugin.dobj", "Lesen der Benutzereinstellungen " + String.valueOf(art) + " - " + s + " ist fehlgeschlagen.", (Throwable)ex));
                        return null;
                    }
                }).filter(p -> p != null).findFirst();
                if (!parameter.isPresent()) continue;
                return this.getModellEinstellungenDiagnostic(parameter.get());
            }
            catch (IOException ex) {
                logger.warning(ex.getLocalizedMessage());
            }
        }
        return Collections.emptyList();
    }
}

