/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.util;

import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung;
import de.bsvrz.buv.plugin.dobj.util.Projektion;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;

public class QuadratischePlattkarteProjektion
implements Projektion {
    private static final int DEFAULT_SKALIERUNG = 1000000;
    private double minimaleGeographischeLaenge;
    private double maximaleGeographischeBreite;
    private double laengenKorrektur;

    public double getLaengenKorrektur() {
        return this.laengenKorrektur;
    }

    public void setDarstellung(Darstellung darstellung) {
        Assert.isLegal((boolean)(darstellung instanceof MassstaeblicheDarstellung));
        MassstaeblicheDarstellung md = (MassstaeblicheDarstellung)darstellung;
        this.minimaleGeographischeLaenge = md.getMinimaleGeographischeLaenge();
        this.maximaleGeographischeBreite = md.getMaximaleGeographischeBreite();
        double minimaleGeographischeBreite = md.getMinimaleGeographischeBreite();
        double breiteInRad = minimaleGeographischeBreite + (this.maximaleGeographischeBreite - minimaleGeographischeBreite) / 2.0;
        breiteInRad = breiteInRad / 360.0 * 2.0 * Math.PI;
        this.laengenKorrektur = Math.cos(breiteInRad);
    }

    @Override
    public Point umrechnenModellNachWelt(Point modell) {
        double dx = modell.preciseX();
        double dy = modell.preciseY();
        dx /= 1000000.0;
        dy /= 1000000.0;
        dx /= this.getLaengenKorrektur();
        dy = this.maximaleGeographischeBreite - dy;
        return new PrecisionPoint(dx += this.minimaleGeographischeLaenge, dy);
    }

    @Override
    public Point umrechnenWeltNachModel(Point welt) {
        double dx = welt.preciseX();
        double dy = welt.preciseY();
        dx -= this.minimaleGeographischeLaenge;
        dy = this.maximaleGeographischeBreite - dy;
        dx *= this.getLaengenKorrektur();
        return new PrecisionPoint(dx *= 1000000.0, dy *= 1000000.0);
    }
}

