/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.views.ansicht;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import de.bsvrz.buv.plugin.darstellung.editparts.DarstellungEditPartFactory;
import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.dobj.preferences.DobjPreference;
import de.bsvrz.buv.plugin.dobj.requests.OnlineRequest;
import de.bsvrz.buv.plugin.dobj.util.DobjUtil;
import de.bsvrz.buv.rw.basislib.legende.ILegendeBaustein;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.ToolTipHelper;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.DomainEventDispatcher;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class AnsichtComposite
extends Composite
implements PropertyChangeListener,
DisposeListener {
    private final EditDomain editDomain = new EditDomain();
    private final ActionRegistry actionRegistry = new ActionRegistry();
    private final ScalableRootEditPart rootEditPart = new ScalableRootEditPart();
    private final GraphicalViewer graphicalViewer;
    private final Ansicht ansicht;
    private boolean online;

    public AnsichtComposite(Composite parent, int style, Ansicht ansicht) {
        super(parent, style);
        this.ansicht = ansicht;
        this.graphicalViewer = this.createGraphicalViewer(this);
        this.setLayout((Layout)new FillLayout());
        this.configureGraphicalViewer(this.graphicalViewer);
        this.editDomain.addViewer((EditPartViewer)this.graphicalViewer);
        RahmenwerkService.getService().getObjektFactory().addPropertyChangeListener((PropertyChangeListener)this);
        this.addDisposeListener(this);
    }

    private GraphicalViewer createGraphicalViewer(Composite parent) {
        AnsichtGraphicalViewer result = new AnsichtGraphicalViewer();
        result.createControl(parent);
        result.getControl().setBackground(ColorConstants.listBackground);
        return result;
    }

    private void configureGraphicalViewer(GraphicalViewer viewer) {
        viewer.setRootEditPart((RootEditPart)this.rootEditPart);
        viewer.setEditPartFactory((EditPartFactory)new DarstellungEditPartFactory());
        viewer.setContents((Object)this.ansicht);
        this.geheOnline();
    }

    private void geheOnline() {
        if (!this.online) {
            Display.getDefault().asyncExec(() -> {
                if (RahmenwerkService.getService().getObjektFactory().isVerbunden()) {
                    for (EditPart editPart : DobjUtil.getAllChildren((EditPart)this.rootEditPart)) {
                        editPart.performRequest((Request)new OnlineRequest(true));
                    }
                    this.online = true;
                }
            });
        }
    }

    private void geheOffline() {
        if (this.online) {
            for (EditPart editPart : DobjUtil.getAllChildren((EditPart)this.rootEditPart)) {
                editPart.performRequest((Request)new OnlineRequest(false));
            }
            this.online = false;
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        RahmenwerkService.getService().getObjektFactory().removePropertyChangeListener((PropertyChangeListener)this);
        this.editDomain.setActiveTool(null);
        this.actionRegistry.dispose();
        this.graphicalViewer.setContents(null);
    }

    public ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    public ZoomManager getZoomManager() {
        return this.rootEditPart.getZoomManager();
    }

    public EditDomain getEditDomain() {
        return this.editDomain;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (RahmenwerkService.getService().getObjektFactory().isVerbunden()) {
            this.geheOnline();
        } else {
            this.geheOffline();
        }
    }

    public Map<DoTyp, ILegendeBaustein> getBausteine() {
        return this.getBausteine((EditPart)this.rootEditPart);
    }

    private Map<DoTyp, ILegendeBaustein> getBausteine(EditPart editPart) {
        Ebene ebene;
        TreeMap<DoTyp, ILegendeBaustein> bausteine = new TreeMap<DoTyp, ILegendeBaustein>(Comparator.comparing(Named::getName));
        ILegendeBaustein baustein = (ILegendeBaustein)editPart.getAdapter(ILegendeBaustein.class);
        if (baustein == null) {
            baustein = (ILegendeBaustein)Platform.getAdapterManager().getAdapter((Object)editPart, ILegendeBaustein.class);
        }
        if (editPart.getModel() instanceof Ebene && !(ebene = (Ebene)editPart.getModel()).isVisible()) {
            return Collections.emptyMap();
        }
        Object model = editPart.getModel();
        if (model instanceof DoModel) {
            DoTyp doTyp = ((DoModel)model).getDoTyp();
            if (baustein != null && !bausteine.containsKey(doTyp)) {
                bausteine.put(doTyp, baustein);
            }
        }
        for (Object e : editPart.getChildren()) {
            bausteine.putAll(this.getBausteine((EditPart)e));
        }
        return bausteine;
    }

    public final GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    public class AnsichtEventDispatcher
    extends DomainEventDispatcher {
        public AnsichtEventDispatcher(EditDomain d, EditPartViewer v) {
            super(d, v);
        }

        protected ToolTipHelper getToolTipHelper() {
            ToolTipHelper helper = super.getToolTipHelper();
            helper.setHideDelay(this.getTooltipHideDelay());
            return helper;
        }

        private int getTooltipHideDelay() {
            String tooltipTimeoutStr = DObjPlugin.getDefault().getPreferenceStore().getString(DobjPreference.TOOLTIP_HIDEDELAY.getId());
            if (tooltipTimeoutStr == null || tooltipTimeoutStr.trim().isEmpty()) {
                tooltipTimeoutStr = RahmenwerkService.getService().getRahmenWerk().getRahmenwerkProductProperties().getDefaultDobjTooltipHideDelay();
            }
            if (tooltipTimeoutStr != null && !tooltipTimeoutStr.trim().isEmpty()) {
                try {
                    int result = Integer.parseInt(tooltipTimeoutStr.trim());
                    return result;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 5000;
        }
    }

    public class AnsichtGraphicalViewer
    extends ScrollingGraphicalViewer {
        public void setEditDomain(EditDomain domain) {
            super.setEditDomain(domain);
            this.getLightweightSystem().setEventDispatcher((EventDispatcher)new AnsichtEventDispatcher(domain, (EditPartViewer)this));
        }
    }
}

