/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.views.ansicht;

import de.bsvrz.buv.plugin.darstellung.actions.SelectAusschnittAction;
import de.bsvrz.buv.plugin.darstellung.actions.ToggleEbenenAction;
import de.bsvrz.buv.plugin.darstellung.actions.ToggleOverviewAction;
import de.bsvrz.buv.plugin.darstellung.actions.ToggleSynchronizeSelectionAction;
import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.Ausschnitt;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.util.AnsichtenEinstellungen;
import de.bsvrz.buv.plugin.darstellung.util.BerechtigungenBerechtigungsFunktion;
import de.bsvrz.buv.plugin.darstellung.views.ansicht.AnsichtComposite;
import de.bsvrz.buv.plugin.darstellung.views.ansicht.ViewPanAction;
import de.bsvrz.buv.plugin.darstellung.views.ansicht.ViewRectangleZoomAction;
import de.bsvrz.buv.plugin.dobj.actions.ToggleVerbindungslinieAction;
import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.basislib.legende.ILegende;
import de.bsvrz.buv.rw.basislib.legende.ILegendeBaustein;
import de.bsvrz.buv.rw.basislib.legende.ITreeLegende;
import de.bsvrz.buv.rw.basislib.printing.RwPrintable;
import de.bsvrz.buv.rw.basislib.urlasser.UrlasserInfoDatenDialog;
import de.bsvrz.puk.param.lib.daten.UrlasserInfo;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.nebula.paperclips.core.BigPrint;
import org.eclipse.nebula.paperclips.core.ImagePrint;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.ScalePrint;
import org.eclipse.nebula.paperclips.core.grid.GridColumn;
import org.eclipse.nebula.paperclips.core.grid.GridPrint;
import org.eclipse.nebula.paperclips.core.page.PagePrint;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;

public class AnsichtsView
extends ViewPart
implements ITreeLegende,
ISaveablePart,
RwPrintable,
CommandStackEventListener {
    public static final String VIEW_ID = AnsichtsView.class.getName();
    private AnsichtComposite ansichtComposite;
    private ViewPanAction panAction;
    private ViewRectangleZoomAction rectangleZoomAction;
    private ZoomInAction zoomInAction;
    private ZoomOutAction zoomOutAction;
    private SelectAusschnittAction selectAusschnittAction;
    private Ansicht ansicht;
    private ContributionItem legendeAction;
    private ToggleEbenenAction ebenenAction;
    private ToggleOverviewAction overViewAction;
    private ToggleSynchronizeSelectionAction toggleSynchronizeSelectionAction;
    private ToggleVerbindungslinieAction toggleVerbindungslinieAction;
    private Ausschnitt initialerAusschnitt;
    private String ausschnittName;
    private SpeicherKey speicherOrt;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String secondaryId = site.getSecondaryId();
        if (secondaryId == null) {
            throw new PartInitException("Es wurde kein Name f\u00fcr die anzuzeigende Ansicht angegeben");
        }
        String[] strings = secondaryId.split("\\|");
        this.speicherOrt = SpeicherKey.allgemeinNetzweit();
        String speicherOrtName = this.speicherOrt.getTypBezeichnung();
        String ansichtName = secondaryId;
        if (strings.length > 0) {
            speicherOrtName = strings[0];
            if (strings.length > 1) {
                ansichtName = strings[1];
            }
            if (strings.length > 2) {
                this.ausschnittName = strings[2];
            }
        }
        for (SpeicherKey s : SpeicherKey.getDefaultKeys()) {
            if (!s.getTypBezeichnung().equalsIgnoreCase(speicherOrtName)) continue;
            this.speicherOrt = s;
            break;
        }
        if (ansichtName != null && !ansichtName.isEmpty()) {
            this.ansicht = (Ansicht)AnsichtenEinstellungen.INSTANCE.getModellEinstellungen(this.speicherOrt, ansichtName);
        }
        if (this.ansicht == null) {
            Status status = new Status(2, "de.bsvrz.buv.plugin.dobj", "Die Ansicht \"" + ansichtName + "\" existiert nicht. Die ben\u00f6tigte Ansicht muss vorher angelegt und in den " + this.speicherOrt.getTypBezeichnung() + " Einstellungen unter dem Namen \"" + ansichtName + "\" gespeichert werden.");
            throw new PartInitException((IStatus)status);
        }
        this.initialerAusschnitt = this.ansicht.getAusschnitte().stream().filter(a -> a.getName().equals(this.ausschnittName)).findFirst().orElse(null);
        if (this.initialerAusschnitt == null && this.ausschnittName != null) {
            DObjPlugin.getDefault().getLog().log((IStatus)new Status(2, "de.bsvrz.buv.plugin.dobj", "Der Ausschnitt \"" + this.ausschnittName + "\" konnte in der Ansicht \"" + ansichtName + "\" nicht gefunden werden."));
        }
    }

    public void createPartControl(Composite parent) {
        this.setPartName(this.ansicht.getName());
        this.ansichtComposite = new AnsichtComposite(parent, 0, this.ansicht);
        this.makeActions();
        this.contributeToActionBars();
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.ansichtComposite);
        this.ansichtComposite.getGraphicalViewer().getControl().setMenu(menu);
        this.ansichtComposite.getGraphicalViewer().setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.ansichtComposite.getGraphicalViewer());
        this.getSite().setSelectionProvider((ISelectionProvider)this.ansichtComposite.getGraphicalViewer());
        this.ansichtComposite.getEditDomain().getCommandStack().addCommandStackEventListener((CommandStackEventListener)this);
        if (this.initialerAusschnitt != null) {
            this.selectAusschnitt(this.initialerAusschnitt);
            this.setPartName(this.initialerAusschnitt.getName() + " / " + this.ansicht.getName());
        }
    }

    public void dispose() {
        if (this.ansichtComposite != null && this.ansichtComposite.getEditDomain() != null && this.ansichtComposite.getEditDomain().getCommandStack() != null) {
            this.ansichtComposite.getEditDomain().getCommandStack().removeCommandStackEventListener((CommandStackEventListener)this);
        }
        super.dispose();
    }

    private void makeActions() {
        this.toggleSynchronizeSelectionAction = new ToggleSynchronizeSelectionAction((IWorkbenchPart)this);
        this.toggleVerbindungslinieAction = new ToggleVerbindungslinieAction((IWorkbenchPart)this);
        this.panAction = new ViewPanAction((IAdaptable)this);
        this.ansichtComposite.getActionRegistry().registerAction((IAction)this.panAction);
        this.rectangleZoomAction = new ViewRectangleZoomAction((IAdaptable)this);
        this.ansichtComposite.getActionRegistry().registerAction((IAction)this.rectangleZoomAction);
        ZoomManager zoomManager = this.ansichtComposite.getZoomManager();
        this.selectAusschnittAction = new SelectAusschnittAction((IWorkbenchPart)this);
        this.ansichtComposite.getActionRegistry().registerAction((IAction)this.selectAusschnittAction);
        this.zoomInAction = new ZoomInAction(zoomManager);
        this.ansichtComposite.getActionRegistry().registerAction((IAction)this.zoomInAction);
        this.zoomOutAction = new ZoomOutAction(zoomManager);
        this.ansichtComposite.getActionRegistry().registerAction((IAction)this.zoomOutAction);
        CommandContributionItemParameter parameter = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench(), null, "de.bsvrz.buv.rw.rw.aktion.toggle.legende", 32);
        this.legendeAction = new CommandContributionItem(parameter);
        this.ebenenAction = new ToggleEbenenAction((IWorkbenchPart)this, this.getControl());
        this.ansichtComposite.getActionRegistry().registerAction((IAction)this.ebenenAction);
        this.overViewAction = new ToggleOverviewAction((IWorkbenchPart)this, this.getControl());
        this.ansichtComposite.getActionRegistry().registerAction((IAction)this.overViewAction);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.toggleSynchronizeSelectionAction);
        manager.add((IAction)this.toggleVerbindungslinieAction);
        manager.add((IAction)this.panAction);
        manager.add((IAction)this.rectangleZoomAction);
        manager.add((IAction)this.zoomInAction);
        manager.add((IAction)this.zoomOutAction);
        manager.add((IContributionItem)this.legendeAction);
        manager.add((IAction)this.ebenenAction);
        manager.add((IAction)this.overViewAction);
        manager.add((IAction)this.selectAusschnittAction);
    }

    public void setFocus() {
        if (this.ansichtComposite != null && !this.ansichtComposite.isDisposed()) {
            this.ansichtComposite.setFocus();
        }
    }

    public Object getAdapter(Class adapter) {
        if (EditDomain.class == adapter) {
            return this.ansichtComposite.getEditDomain();
        }
        if (Darstellung.class == adapter) {
            return this.ansicht.getDarstellung();
        }
        if (CommandStack.class == adapter) {
            return this.ansichtComposite.getEditDomain().getCommandStack();
        }
        if (GraphicalViewer.class == adapter) {
            return this.ansichtComposite.getGraphicalViewer();
        }
        if (ZoomManager.class == adapter) {
            return this.ansichtComposite.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        return super.getAdapter(adapter);
    }

    public String getTitel() {
        return this.getPartName();
    }

    public ILegende.Corner getDefaultCorner() {
        return ILegende.Corner.TopLeft;
    }

    public List<ILegendeBaustein> getBausteine() {
        return List.copyOf(this.ansichtComposite.getBausteine().values());
    }

    public Control getControl() {
        return this.ansichtComposite;
    }

    public void doSave(IProgressMonitor monitor) {
        monitor.beginTask("Speichere Ansicht...", -1);
        if (SpeicherKey.allgemeinNetzweit().equals((Object)this.speicherOrt) && BerechtigungenBerechtigungsFunktion.ANSICHT_NETZWERKWEIT_SPEICHERN_OHNE_URLASSER.isFreigegeben()) {
            Rahmenwerk rw = RahmenwerkService.getService().getRahmenWerk();
            UrlasserInfo info = new UrlasserInfo(rw.getBenutzer(), rw.getPasswort(), "Speichern der Ansicht " + this.ansicht.getName(), "");
            try {
                AnsichtenEinstellungen.INSTANCE.setModellEinstellungen(SpeicherKey.allgemeinNetzweit(), this.ansicht.getName(), this.ansicht, info);
                this.ansichtComposite.getEditDomain().getCommandStack().markSaveLocation();
                monitor.worked(1);
            }
            catch (IOException ex) {
                monitor.setCanceled(true);
                String message = "Speichern einer Ansicht ist fehlgeschlagen.";
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Fehler", (String)"Speichern einer Ansicht ist fehlgeschlagen.");
            }
        } else {
            UrlasserInfoDatenDialog dialog = new UrlasserInfoDatenDialog(this.getSite().getShell(), (verbindung, urlasser) -> {
                try {
                    AnsichtenEinstellungen.INSTANCE.setModellEinstellungen(this.speicherOrt, this.ansicht.getName(), this.ansicht, urlasser);
                    this.ansichtComposite.getEditDomain().getCommandStack().markSaveLocation();
                    monitor.worked(1);
                }
                catch (IOException ex) {
                    monitor.setCanceled(true);
                    String message = "Speichern einer Ansicht ist fehlgeschlagen.";
                    MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Fehler", (String)"Speichern einer Ansicht ist fehlgeschlagen.");
                }
            });
            dialog.open();
        }
        monitor.done();
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        if (this.ansichtComposite == null || this.ansichtComposite.isDisposed()) {
            return false;
        }
        return this.ansichtComposite.getEditDomain().getCommandStack().isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public PagePrint getDruckAuftrag() {
        GridPrint grid = new GridPrint();
        grid.addColumn(new GridColumn(16384, -1, 0));
        Display d = this.getSite().getShell().getDisplay();
        GraphicalEditPart rootEditPart = (GraphicalEditPart)this.ansichtComposite.getGraphicalViewer().getRootEditPart();
        Rectangle swtR = new Rectangle(rootEditPart.getFigure().getBounds().x, rootEditPart.getFigure().getBounds().y, rootEditPart.getFigure().getBounds().width, rootEditPart.getFigure().getBounds().height);
        Image image = new Image((Device)d, swtR);
        GC gc = new GC((Drawable)image);
        SWTGraphics swtg = new SWTGraphics(gc);
        rootEditPart.getFigure().paint((Graphics)swtg);
        swtg.dispose();
        gc.dispose();
        grid.add((Print)new ImagePrint(image.getImageData()));
        if (MessageDialog.openQuestion((Shell)this.getViewSite().getShell(), (String)"Ausdruck skalieren?", (String)"Soll der Ausdruck auf genau 1 Seite skaliert werden?")) {
            return new PagePrint((Print)new ScalePrint((Print)new BigPrint((Print)grid)));
        }
        return new PagePrint((Print)new BigPrint((Print)grid));
    }

    private void selectAusschnitt(Ausschnitt ausschnitt) {
        ZoomManager zoomManager = this.ansichtComposite.getZoomManager();
        zoomManager.setZoom(ausschnitt.getZoomLevel());
        zoomManager.getViewport().setHorizontalLocation(ausschnitt.getBounds().x);
        zoomManager.getViewport().setVerticalLocation(ausschnitt.getBounds().y);
    }

    public void stackChanged(CommandStackEvent event) {
        this.firePropertyChange(257);
        this.ansichtComposite.getEditDomain().getCommandStack();
    }

    public boolean isLegendeEnabled() {
        return this.ansicht.getDarstellung().isLegendeAktivieren();
    }
}

