/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.wizards;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import com.bitctrl.lib.eclipse.emf.util.EmfUtil;
import de.bsvrz.buv.plugin.darstellung.wizards.AbstractExportWizardPage;
import de.bsvrz.buv.plugin.darstellung.wizards.AbstractWorkbenchWizard;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractExportWizard
extends AbstractWorkbenchWizard
implements IExportWizard {
    private AbstractExportWizardPage exportPage;

    protected AbstractExportWizard(EClass eClass) {
        super(eClass);
    }

    public void addPages() {
        this.exportPage = this.createExportPage();
        this.exportPage.setPreSelection((ISelection)this.getSelection());
        this.addPage((IWizardPage)this.exportPage);
    }

    protected abstract AbstractExportWizardPage createExportPage();

    public boolean performFinish() {
        String directory = this.exportPage.getDirectory();
        ResourceSetImpl resSet = new ResourceSetImpl();
        IStructuredSelection export = (IStructuredSelection)this.exportPage.getSelection();
        for (Object e : export.toList()) {
            if (!this.getEClass().isInstance(e)) continue;
            Named object = (Named)e;
            File file = new File(directory + "/" + object.getName() + "." + this.getEClass().getName().toLowerCase());
            if (file.exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)"Datei \u00fcberschreiben", (String)("Es existiert bereits eine Datei mit dem selben Namen " + String.valueOf(file) + ". Wollen Sie diese \u00fcberschreiben?"))) {
                return false;
            }
            Resource resource = resSet.createResource(URI.createURI((String)file.toURI().toString()));
            resource.getContents().add((Object)object);
            try {
                resource.save(null);
            }
            catch (IOException ex) {
                String message = "Die Datei konnte nicht geschrieben werden: " + EmfUtil.getText((EObject)object);
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Fehler beim Export", (String)message, (IStatus)Status.error((String)message, (Throwable)ex));
                return false;
            }
        }
        return true;
    }
}

