/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.wizards;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import de.bsvrz.buv.plugin.darstellung.wizards.AbstractImportWizardPage;
import de.bsvrz.buv.plugin.darstellung.wizards.AbstractWorkbenchWizard;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungLocation;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungOwnerType;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.basislib.einstellungen.UrlasserDialogAbgebrochenException;
import de.bsvrz.buv.rw.basislib.urlasser.UrlasserInfoDatenDialog;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.EMFModellEinstellungen;
import de.bsvrz.buv.rw.bitctrl.eclipse.wizards.EinstellungsArtWizardPage;
import de.bsvrz.puk.param.lib.daten.UrlasserInfo;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractImportWizard
extends AbstractWorkbenchWizard {
    private final EMFModellEinstellungen einstellungen;
    private AbstractImportWizardPage importPage;
    private EinstellungsArtWizardPage einstellungsArtWizardPage;

    protected AbstractImportWizard(EClass eClass, EMFModellEinstellungen<?> einstellungen) {
        super(eClass);
        this.einstellungen = einstellungen;
    }

    public void addPages() {
        this.importPage = this.getImportWizardPage();
        this.addPage((IWizardPage)this.importPage);
        this.einstellungsArtWizardPage = new EinstellungsArtWizardPage(EinstellungsArtWizardPage.class.getName());
        HashSet<SpeicherKey> einstellungsArten = new HashSet<SpeicherKey>();
        for (Object e : this.getSelection().toList()) {
            if (!(e instanceof SpeicherKey)) continue;
            SpeicherKey key = (SpeicherKey)e;
            einstellungsArten.add(key);
        }
        this.einstellungsArtWizardPage.setPreSelection(einstellungsArten);
        this.addPage((IWizardPage)this.einstellungsArtWizardPage);
    }

    protected abstract AbstractImportWizardPage getImportWizardPage();

    public boolean performFinish() {
        List<String> fileNames = this.importPage.getFileNames();
        for (SpeicherKey einstellungsArt : this.einstellungsArtWizardPage.getEinstellungsArten()) {
            if (einstellungsArt.getLocation() == EinstellungLocation.NETZWERKWEIT && einstellungsArt.getOwnerType() == EinstellungOwnerType.SYSTEM) {
                UrlasserInfoDatenDialog dialog = new UrlasserInfoDatenDialog(this.getShell(), (verbindung, urlasser) -> {
                    for (String fileName : fileNames) {
                        IStatus status = this.dateiImportieren(einstellungsArt, fileName, urlasser);
                        if (!status.matches(4)) continue;
                        return;
                    }
                });
                dialog.open();
                continue;
            }
            for (String fileName : fileNames) {
                IStatus status = this.dateiImportieren(einstellungsArt, fileName, null);
                if (!status.matches(4)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IStatus dateiImportieren(SpeicherKey einstellungsArt, String fileName, UrlasserInfo urlasser) {
        String message;
        Resource resource;
        File file;
        block9: {
            ResourceSetImpl resSet = new ResourceSetImpl();
            file = new File(fileName);
            resource = resSet.createResource(URI.createURI((String)file.toURI().toString()));
            try {
                resource.load(null);
            }
            catch (IOException ex) {
                message = "Die Datei\n" + String.valueOf(file) + "\nenth\u00e4lt mind. einen Fehler.\n\nM\u00f6chten Sie die Darstellung trotz der Fehler importieren?\n\nDabei w\u00fcrden die fehlenden Darstellungsobjekte aus der Darstellung entfernt. Andernfalls installieren Sie bitte zun\u00e4chst die notwendigen Darstellungsobjekte!";
                List<IStatus> errors = this.readErrors(resource);
                MultiStatus multiStatus = new MultiStatus("de.bsvrz.buv.plugin.dobj", 4, "", null);
                errors.stream().forEach(arg_0 -> ((MultiStatus)multiStatus).add(arg_0));
                QuestionErrorDialog dialog = new QuestionErrorDialog(this.getShell(), "Fehler beim Import", message, (IStatus)multiStatus, 7);
                if (1 != dialog.open()) break block9;
                return Status.error((String)message, (Throwable)ex);
            }
        }
        EList contents = resource.getContents();
        if (contents.size() != 1) {
            message = "Die Datei ist fehlerhaft und kann nicht gelesen werden: " + String.valueOf(file);
            IStatus status = Status.error((String)message);
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Fehler beim Import", (String)message, (IStatus)status);
            return status;
        }
        Named named = (Named)contents.get(0);
        named.eAllContents().forEachRemaining(e -> {
            if (EcoreUtil.getID((EObject)e) != null) {
                EcoreUtil.setID((EObject)e, (String)EcoreUtil.generateUUID());
            }
        });
        if (EcoreUtil.getID((EObject)named) != null) {
            EcoreUtil.setID((EObject)named, (String)EcoreUtil.generateUUID());
        }
        try {
            if (this.einstellungen.getModellEinstellungen(einstellungsArt, named.getName()) != null) {
                if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)(this.getEClass().getInstanceTypeName() + " \u00fcberschreiben"), (String)("Es existiert bereits ein Objekt mit dem selben Namen " + named.getName() + ". Wollen Sie es \u00fcberschreiben?"))) return Status.CANCEL_STATUS;
                this.einstellungen.setModellEinstellungen(einstellungsArt, named.getName(), (Object)named, urlasser);
                return Status.OK_STATUS;
            } else {
                this.einstellungen.setModellEinstellungen(einstellungsArt, named.getName(), (Object)named, urlasser);
            }
            return Status.OK_STATUS;
        }
        catch (UrlasserDialogAbgebrochenException ex) {
            return Status.CANCEL_STATUS;
        }
        catch (IOException ex) {
            Status status = new Status(4, "de.bsvrz.buv.plugin.dobj", ex.getLocalizedMessage(), (Throwable)ex);
            ErrorDialog.openError((Shell)this.importPage.getShell(), (String)"FEHLER", (String)"Der Import konnte nicht erfolgreich ausgef\u00fchrt werden!", (IStatus)status);
            return status;
        }
    }

    private List<IStatus> readErrors(Resource resource) {
        EList errors = resource.getErrors();
        List<String> collect = errors.stream().filter(d -> d instanceof PackageNotFoundException).map(e -> (PackageNotFoundException)e).map(c -> c.uri()).distinct().toList();
        return collect.stream().map(s -> new Status(4, "de.bsvrz.buv.plugin.dobj", "Das Darstellungsobjekt mit der Package-URI '" + s + "' ist nicht installiert.")).collect(Collectors.toList());
    }

    private static final class QuestionErrorDialog
    extends ErrorDialog {
        public QuestionErrorDialog(Shell parentShell, String dialogTitle, String message, IStatus status, int displayMask) {
            super(parentShell, dialogTitle, message, status, displayMask);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
            this.createButton(parent, 3, IDialogConstants.NO_LABEL, false);
            this.createDetailsButton(parent);
        }

        protected void buttonPressed(int buttonId) {
            switch (buttonId) {
                case 2: {
                    this.setReturnCode(0);
                    this.close();
                    break;
                }
                case 3: {
                    this.setReturnCode(1);
                    this.close();
                    break;
                }
                default: {
                    super.buttonPressed(buttonId);
                }
            }
        }
    }
}

