/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.wizards;

import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.util.AnsichtenEinstellungen;
import de.bsvrz.buv.plugin.darstellung.wizards.AbstractWorkbenchWizard;
import de.bsvrz.buv.plugin.darstellung.wizards.AnsichtNewWizardPage;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.basislib.einstellungen.UrlasserDialogAbgebrochenException;
import de.bsvrz.buv.rw.bitctrl.eclipse.wizards.EinstellungsArtWizardPage;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;

public class AnsichtNewWizard
extends AbstractWorkbenchWizard
implements INewWizard {
    public static final String WIZARD_ID = AnsichtNewWizard.class.getName();
    private AnsichtNewWizardPage ansichtPage;
    private EinstellungsArtWizardPage einstellungsArtPage;

    public AnsichtNewWizard() {
        super(DarstellungPackage.Literals.ANSICHT);
    }

    public void addPages() {
        this.ansichtPage = new AnsichtNewWizardPage(AnsichtNewWizardPage.class.getName());
        this.addPage((IWizardPage)this.ansichtPage);
        this.einstellungsArtPage = new EinstellungsArtWizardPage(EinstellungsArtWizardPage.class.getName());
        this.einstellungsArtPage.setMultiple(false);
        this.addPage((IWizardPage)this.einstellungsArtPage);
    }

    public boolean performFinish() {
        Ansicht ansicht = this.ansichtPage.getAnsicht();
        SpeicherKey art = this.einstellungsArtPage.getFirstEinstellungsArt();
        if (AnsichtenEinstellungen.INSTANCE.getModellEinstellungen(art, ansicht.getName()) != null) {
            if (MessageDialog.openQuestion((Shell)this.getShell(), (String)"Ansicht  \u00fcberschreiben", (String)("Eine Ansicht mit dem Namen \"" + ansicht.getName() + "\" existiert bereits in den Einstellungen \"" + String.valueOf(art) + "\".\n\nWollen Sie diese Ansicht \u00fcberschreiben? Diese Aktion kann nicht r\u00fcckg\u00e4ngig gemacht werden."))) {
                try {
                    AnsichtenEinstellungen.INSTANCE.setModellEinstellungen(art, ansicht.getName(), ansicht);
                    return true;
                }
                catch (UrlasserDialogAbgebrochenException ex) {
                    return false;
                }
                catch (IOException ex) {
                    ErrorDialog.openError((Shell)this.ansichtPage.getShell(), (String)"FEHLER", (String)"Ansicht konnte nicht angelegt werden!", (IStatus)new Status(4, "de.bsvrz.buv.plugin.dobj", ex.getLocalizedMessage(), (Throwable)ex));
                    return false;
                }
            }
            return false;
        }
        try {
            AnsichtenEinstellungen.INSTANCE.setModellEinstellungen(art, ansicht.getName(), ansicht);
            return true;
        }
        catch (UrlasserDialogAbgebrochenException ex) {
            return false;
        }
        catch (IOException ex) {
            ErrorDialog.openError((Shell)this.ansichtPage.getShell(), (String)"FEHLER", (String)"Ansicht konnte nicht angelegt werden!", (IStatus)new Status(4, "de.bsvrz.buv.plugin.dobj", ex.getLocalizedMessage(), (Throwable)ex));
            return false;
        }
    }
}

