/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj;

import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.dobj.DoFigure;
import de.bsvrz.buv.plugin.dobj.editparts.DoModelEditPart;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.ZoomStufe;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.GraphicalEditPart;

public final class DoMediator {
    private final DoModelEditPart<?, ?> editPart;

    public DoMediator(DoModelEditPart<?, ?> editPart) {
        this.editPart = editPart;
    }

    public void mediate() {
        this.mediateLocation();
        this.mediateZoomStufe();
        this.mediateZoom();
    }

    private void mediateLocation() {
        DoModel model = (DoModel)this.editPart.getModel();
        Point location = model.getAbsoluteLocation();
        if (location != null) {
            DoFigure f = this.getFigure();
            f.setHotspot(location);
            GraphicalEditPart parent = (GraphicalEditPart)this.editPart.getParent();
            parent.setLayoutConstraint(this.editPart, (IFigure)f, (Object)f.getBounds());
        }
    }

    private void mediateZoomStufe() {
        double bisZoom;
        double vonZoom;
        DoModel model = (DoModel)this.editPart.getModel();
        ZoomStufe zoomStufe = model.getDoTyp().getZoomStufe();
        if (zoomStufe != null) {
            double zoomSkalierung = this.getZoomSkalierung();
            vonZoom = zoomStufe.getVonLevel();
            vonZoom /= 100.0;
            vonZoom /= zoomSkalierung;
            bisZoom = zoomStufe.getBisLevel();
            bisZoom /= 100.0;
            bisZoom /= zoomSkalierung;
        } else {
            vonZoom = 0.0;
            bisZoom = Double.MAX_VALUE;
        }
        this.getFigure().setSichtbareZoomStufe(vonZoom, bisZoom);
    }

    private double getZoomSkalierung() {
        Darstellung darstellung = this.editPart.getDarstellung();
        if (darstellung != null) {
            return darstellung.getZoomSkalierung();
        }
        return 1.0;
    }

    private void mediateZoom() {
        double zoom = this.editPart.getZoomManager().getZoom();
        this.getFigure().handleZoomChanged(zoom);
    }

    private DoFigure getFigure() {
        return (DoFigure)this.editPart.getFigure();
    }
}

