/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.actions;

import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class PasteDobjAction
extends SelectionAction {
    private static final Debug LOGGER = Debug.getLogger();

    public PasteDobjAction(IWorkbenchPart editor) {
        super(editor);
    }

    protected boolean calculateEnabled() {
        return this.createPasteCommand() != null;
    }

    protected Command createPasteCommand() {
        Object obj;
        CompoundCommand result = new CompoundCommand();
        List selection = this.getSelectedObjects();
        if (selection != null && selection.size() == 1 && (obj = selection.get(0)) instanceof GraphicalEditPart) {
            GraphicalEditPart gep = (GraphicalEditPart)obj;
            try {
                List templates = (List)this.getClipboardContents();
                if (templates != null) {
                    block2: for (DoModel template : templates) {
                        CreationFactory factory = this.getFactory(template);
                        if (factory == null) continue;
                        CreateRequest request = new CreateRequest();
                        request.setFactory(factory);
                        request.setLocation(this.getPasteLocation(gep, templates, template));
                        EditPart targetEditPart = gep.getTargetEditPart((Request)request);
                        GraphicalEditPart editpart = gep;
                        do {
                            Command cmd;
                            if (targetEditPart != null && (cmd = targetEditPart.getCommand((Request)request)) != null) {
                                result.add(cmd);
                                continue block2;
                            }
                            if ((editpart = editpart.getParent()) == null) continue;
                            targetEditPart = editpart.getTargetEditPart((Request)request);
                        } while (targetEditPart != null && editpart != null);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.warning("Fehler beim Auslesen des Clipboards: " + ex.getLocalizedMessage());
            }
        }
        return result;
    }

    protected Object getClipboardContents() {
        return Clipboard.getDefault().getContents();
    }

    protected CreationFactory getFactory(Object template) {
        if (template instanceof DoModel) {
            return new CloneCreationFactory((DoModel)template);
        }
        return null;
    }

    protected Point getPasteLocation(GraphicalEditPart container, List<DoModel> templates, DoModel template) {
        Point result;
        GraphicalViewer viewer = (GraphicalViewer)this.getWorkbenchPart().getAdapter(GraphicalViewer.class);
        Control control = viewer.getControl();
        Point mouse = new Point(control.toControl(control.getDisplay().getCursorLocation()));
        if (mouse.x >= 0 && mouse.y >= 0) {
            PointList points = new PointList();
            for (DoModel m : templates) {
                if (m.getLocation() == null) continue;
                points.addPoint(m.getLocation());
            }
            Rectangle bounds = points.getBounds();
            Point p = template.getLocation();
            int dx = p.x - bounds.x;
            int dy = p.y - bounds.y;
            result = new Point(mouse.x + dx, mouse.y + dy);
        } else {
            result = new Point(10, 10);
        }
        return result;
    }

    protected void init() {
        this.setId(ActionFactory.PASTE.getId());
        this.setText("Einf\u00fcgen");
    }

    public void run() {
        this.execute(this.createPasteCommand());
    }

    private static final class CloneCreationFactory
    implements CreationFactory {
        private final DoModel model;

        CloneCreationFactory(DoModel model) {
            this.model = model;
        }

        public Object getObjectType() {
            return this.model.getDoTyp();
        }

        public Object getNewObject() {
            return EcoreUtil.copy((EObject)this.model);
        }
    }
}

