/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.decorator;

import de.bsvrz.buv.plugin.darstellung.editparts.EbeneEditPart;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.dobj.editparts.DoModelEditPart;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.resource.ResourceManager;

public abstract class AbstractMediator<D extends EObject, F extends IFigure> {
    private final DoModelEditPart<?, ?> editPart;
    private final Class<D> decoratorType;
    private final EStructuralFeature feature;

    protected AbstractMediator(DoModelEditPart<?, ?> editPart, Class<D> decoratorType, EStructuralFeature feature) {
        this.editPart = editPart;
        this.decoratorType = decoratorType;
        this.feature = feature;
    }

    protected final DoModelEditPart<?, ?> getEditPart() {
        return this.editPart;
    }

    public final void mediate() {
        if (this.useModelValue()) {
            this.mediate(this.getModel());
        } else {
            EditPart parent = this.editPart.getParent();
            if (parent instanceof EbeneEditPart) {
                EbeneEditPart ebenenEditPart = (EbeneEditPart)parent;
                this.mediate(this.findEbeneDoTyp(ebenenEditPart));
            } else {
                this.mediate(this.getDoTyp());
            }
        }
    }

    private D findEbeneDoTyp(EbeneEditPart ebene) {
        EList<DoTyp> ebeneDoTypen = ((Ebene)ebene.getModel()).getEbeneDoTypen();
        Optional<DoTyp> findFirst = ebeneDoTypen.stream().filter(t -> t.eIsSet(this.feature) && this.decoratorType.isInstance(t) && Objects.equals(t.getId(), ((DoModel)this.editPart.getModel()).getDoTyp().getId())).findFirst();
        if (findFirst.isPresent()) {
            return (D)((EObject)findFirst.get());
        }
        EditPart parent = ebene.getParent();
        if (parent instanceof EbeneEditPart) {
            EbeneEditPart ebenenEditPart = (EbeneEditPart)parent;
            return this.findEbeneDoTyp(ebenenEditPart);
        }
        return this.getDoTyp();
    }

    private boolean useModelValue() {
        return this.isModelDecorated() && this.getModel().eIsSet(this.feature) || !this.isDoTypDecorated();
    }

    protected abstract void mediate(D var1);

    private boolean isModelDecorated() {
        return this.decoratorType.isInstance(this.editPart.getModel());
    }

    protected final D getModel() {
        return (D)this.editPart.getModel();
    }

    private boolean isDoTypDecorated() {
        return this.decoratorType.isInstance(((DoModel)this.editPart.getModel()).getDoTyp());
    }

    protected final D getDoTyp() {
        return (D)((DoModel)this.editPart.getModel()).getDoTyp();
    }

    protected final F getFigure() {
        return (F)this.editPart.getFigure();
    }

    protected final ResourceManager getResourceManager() {
        return this.editPart.getViewer().getResourceManager();
    }
}

