/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.decorator.legende;

import de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.legende.DoLegendeBaustein;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class FarbeDoLegendeBaustein
extends DoLegendeBaustein {
    private Color foregroundColor;
    private Color backgroundColor;

    public FarbeDoLegendeBaustein(DoTyp doTyp, IFigure figure) {
        super(doTyp, figure);
        Display display = PlatformUI.getWorkbench().getDisplay();
        this.handleVordergrundfarbeDecorator(display);
        this.handleHintergrundfarbeDecorator(display);
    }

    private void handleVordergrundfarbeDecorator(Display display) {
        if (this.getDoTyp() instanceof VordergrundfarbeDecorator) {
            VordergrundfarbeDecorator decorator = (VordergrundfarbeDecorator)((Object)this.getDoTyp());
            RGB rgb = decorator.getVordergrundfarbe();
            this.foregroundColor = new Color((Device)display, rgb);
            this.getFigure().setForegroundColor(this.foregroundColor);
        }
    }

    private void handleHintergrundfarbeDecorator(Display display) {
        if (this.getDoTyp() instanceof HintergrundfarbeDecorator) {
            HintergrundfarbeDecorator decorator = (HintergrundfarbeDecorator)((Object)this.getDoTyp());
            RGB rgb = decorator.getHintergrundfarbe();
            this.backgroundColor = new Color((Device)display, rgb);
            this.getFigure().setBackgroundColor(this.backgroundColor);
        }
    }

    @Override
    public void dispose() {
        if (this.foregroundColor != null) {
            this.foregroundColor.dispose();
        }
        if (this.backgroundColor != null) {
            this.backgroundColor.dispose();
        }
        super.dispose();
    }
}

