/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.editors;

import com.bitctrl.lib.eclipse.emf.util.EmfUtil;
import de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.dobj.util.DoTypenUtil;
import de.bsvrz.dav.daf.main.config.SystemObjectInfo;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.bitctrl.util.SystemObjectComparator;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteToolbar;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;

public class DobjEditorPaletteFactory {
    private final List<SystemObjectType> systemObjectTypes;
    private final Map<SystemObjectType, List<DoTyp>> doTypen = new HashMap<SystemObjectType, List<DoTyp>>();
    private final List<DoTyp> doTypenOhneSystemObjekt = new ArrayList<DoTyp>();

    public DobjEditorPaletteFactory() {
        for (DoTyp doTyp : DoTypenUtil.getDoTypen()) {
            SystemObjectType type = doTyp.getSystemObjectType();
            if (type != null) {
                if (!this.doTypen.containsKey(type)) {
                    this.doTypen.put(type, new ArrayList());
                }
                this.doTypen.get(type).add(doTyp);
                continue;
            }
            this.doTypenOhneSystemObjekt.add(doTyp);
        }
        this.systemObjectTypes = new ArrayList<SystemObjectType>();
        this.systemObjectTypes.addAll(this.doTypen.keySet());
        Collections.sort(this.systemObjectTypes, new SystemObjectComparator());
        Collections.sort(this.doTypenOhneSystemObjekt, new DoTypComparator());
        for (List list : this.doTypen.values()) {
            Collections.sort(list, new DoTypComparator());
        }
    }

    public PaletteRoot createPalette() {
        PaletteRoot palette = new PaletteRoot();
        palette.add((PaletteEntry)this.createToolsGroup(palette));
        palette.addAll(this.createDoTypenDrawers());
        return palette;
    }

    protected PaletteToolbar createToolsGroup(PaletteRoot palette) {
        PaletteToolbar toolbar = new PaletteToolbar("Tools");
        PanningSelectionToolEntry tool = new PanningSelectionToolEntry();
        toolbar.add((PaletteEntry)tool);
        palette.setDefaultEntry((ToolEntry)tool);
        toolbar.add((PaletteEntry)new MarqueeToolEntry());
        return toolbar;
    }

    protected List<PaletteContainer> createDoTypenDrawers() {
        ArrayList<PaletteContainer> result = new ArrayList<PaletteContainer>();
        for (SystemObjectType systemObjectType : this.systemObjectTypes) {
            PaletteContainer systemObjectTypeDrawer = this.createSystemObjectTypeDrawer(systemObjectType);
            if (systemObjectTypeDrawer.getChildren().isEmpty()) continue;
            result.add(systemObjectTypeDrawer);
        }
        result.add(this.createOtherDrawer());
        return result;
    }

    private PaletteContainer createSystemObjectTypeDrawer(SystemObjectType systemObjectType) {
        PaletteDrawer result = new PaletteDrawer(systemObjectType.getName());
        SystemObjectInfo info = systemObjectType.getInfo();
        String description = info.getShortInfo().replaceAll("\\s+", " ").trim();
        result.setDescription(description);
        result.setInitialState(1);
        for (DoTyp doTyp : this.doTypen.get(systemObjectType)) {
            IItemLabelProvider labelProvider;
            if (doTyp instanceof ConfiguratedDoTyp && ((ConfiguratedDoTyp)doTyp).isNurMassstaeblicheDarstellung()) continue;
            ImageDescriptor icon = doTyp.getIcon();
            if (icon == null && (labelProvider = EmfUtil.getItemLabelProvider((EObject)doTyp)) != null) {
                Object image = labelProvider.getImage((Object)doTyp);
                if (image instanceof ImageDescriptor) {
                    icon = (ImageDescriptor)image;
                } else if (image instanceof URL) {
                    icon = ImageDescriptor.createFromURL((URL)((URL)image));
                }
            }
            String name = doTyp.getName();
            Object tooltip = doTyp.getDescription();
            if (tooltip == null || ((String)tooltip).isEmpty()) {
                tooltip = name;
            }
            tooltip = (String)tooltip + " (" + doTyp.getId() + ")";
            CreationToolEntry entry = new CreationToolEntry(name, (String)tooltip, this.getCreationFactory(doTyp), icon, icon);
            result.add((PaletteEntry)entry);
        }
        return result;
    }

    private PaletteContainer createOtherDrawer() {
        PaletteDrawer result = new PaletteDrawer("Andere");
        for (DoTyp doTyp : this.doTypenOhneSystemObjekt) {
            String name = doTyp.getName();
            String tooltip = doTyp.getDescription();
            ImageDescriptor icon = doTyp.getIcon();
            CreationToolEntry entry = new CreationToolEntry(name, tooltip, this.getCreationFactory(doTyp), icon, icon);
            result.add((PaletteEntry)entry);
        }
        return result;
    }

    protected CreationFactory getCreationFactory(DoTyp doTyp) {
        return new DoTypCreationFactory(doTyp);
    }

    private static class DoTypComparator
    implements Comparator<DoTyp> {
        private DoTypComparator() {
        }

        @Override
        public int compare(DoTyp o1, DoTyp o2) {
            return Collator.getInstance().compare(o1.getName(), o2.getName());
        }
    }

    private static class DoTypCreationFactory
    implements CreationFactory {
        private final DoTyp doTyp;

        DoTypCreationFactory(DoTyp doTyp) {
            this.doTyp = doTyp;
        }

        public Object getNewObject() {
            return this.doTyp.createModel();
        }

        public Object getObjectType() {
            return this.doTyp;
        }
    }
}

