/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.editors;

import com.bitctrl.lib.eclipse.draw2d.parts.ScrollableThumbnail2;
import com.bitctrl.lib.eclipse.draw2d.parts.Thumbnail2;
import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import com.bitctrl.lib.eclipse.emf.util.EmfUtil;
import de.bsvrz.buv.plugin.dobj.actions.PanAction;
import de.bsvrz.buv.plugin.dobj.actions.RectangleZoomAction;
import de.bsvrz.buv.plugin.dobj.actions.SelectAllAction;
import de.bsvrz.buv.plugin.dobj.editors.DobjContextMenuProvider;
import de.bsvrz.buv.plugin.dobj.editors.DobjEditDomain;
import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.dobj.requests.OnlineRequest;
import de.bsvrz.buv.plugin.dobj.tools.DObjSelectionTool;
import de.bsvrz.buv.plugin.dobj.util.DobjUtil;
import de.bsvrz.sys.funclib.bitctrl.daf.DavProvider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.EventObject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class DobjGraphicalEditor<T extends Named>
extends GraphicalEditor
implements ITabbedPropertySheetPageContributor {
    private VerbundenPropertyChangeListener verbundenPropertyChangeListener;
    private DavProvider davProvider;
    private boolean online;
    private KeyHandler sharedKeyHandler;
    private T model;
    private final Class<T> modelClass;
    private Image titleImage;
    private SelectionSynchronizer synchronizer;

    protected DobjGraphicalEditor(Class<T> modelClass) {
        this.modelClass = modelClass;
        this.setEditDomain(new DobjEditDomain((IEditorPart)this));
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.davProvider = RahmenwerkService.getService().getObjektFactory();
        this.online = this.davProvider.isVerbunden();
        this.verbundenPropertyChangeListener = new VerbundenPropertyChangeListener();
        this.davProvider.addPropertyChangeListener("verbunden", (PropertyChangeListener)this.verbundenPropertyChangeListener);
    }

    private void updateOnline() {
        Shell shell = this.getSite().getWorkbenchWindow().getShell();
        if (shell != null) {
            shell.getDisplay().asyncExec(() -> {
                if (this.online) {
                    this.geheOnline();
                } else {
                    this.geheOffline();
                }
            });
        }
    }

    protected void createGraphicalViewer(Composite parent) {
        ScrollingGraphicalViewer viewer = new ScrollingGraphicalViewer();
        viewer.createControl(parent);
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
    }

    public boolean isOnline() {
        return this.online;
    }

    protected void geheOnline() {
        this.getGraphicalViewer().getControl().setEnabled(true);
        this.setContentDescription("");
        for (EditPart editPart : DobjUtil.getAllChildren((EditPart)this.getGraphicalViewer().getRootEditPart())) {
            editPart.performRequest((Request)new OnlineRequest(true));
        }
    }

    protected void geheOffline() {
        Control control = this.getGraphicalViewer().getControl();
        if (control != null && !control.isDisposed()) {
            control.setEnabled(false);
            this.setContentDescription("Keine Verbindung zum Datenverteiler.");
            for (EditPart editPart : DobjUtil.getAllChildren((EditPart)this.getGraphicalViewer().getRootEditPart())) {
                editPart.performRequest((Request)new OnlineRequest(false));
            }
        }
    }

    protected T getModel() {
        return this.model;
    }

    protected Class<T> getModelClass() {
        return this.modelClass;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.model = (Named)EcoreUtil.copy((EObject)((Named)input.getAdapter(this.getModelClass())));
        this.setPartName(this.model.getName());
        Object image = EmfUtil.getImage(this.model);
        if (image instanceof Image) {
            this.titleImage = (Image)image;
        } else if (image instanceof ImageDescriptor) {
            this.titleImage = ((ImageDescriptor)image).createImage();
        }
        if (this.titleImage != null) {
            this.setTitleImage(this.titleImage);
        }
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new SelectionSynchronizer();
        }
        return this.synchronizer;
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        ScalableRootEditPart rootEditPart = new ScalableRootEditPart(){

            protected LayeredPane createPrintableLayers() {
                LayeredPane pane = new LayeredPane();
                ConnectionLayer layer = new ConnectionLayer();
                layer.setPreferredSize(new Dimension(5, 5));
                pane.add((IFigure)layer, (Object)"Connection Layer");
                layer = new Layer();
                layer.setLayoutManager((LayoutManager)new StackLayout());
                pane.add((IFigure)layer, (Object)"Primary Layer");
                return pane;
            }
        };
        this.getGraphicalViewer().setRootEditPart((RootEditPart)rootEditPart);
        this.getGraphicalViewer().setEditPartFactory(this.getEditPartFactory());
        this.getGraphicalViewer().setKeyHandler(new GraphicalViewerKeyHandler(this.getGraphicalViewer()).setParent(this.getCommonKeyHandler()));
        this.configureZoomManager(rootEditPart.getZoomManager());
        ZoomInAction zoomIn = new ZoomInAction(rootEditPart.getZoomManager());
        this.getActionRegistry().registerAction((IAction)zoomIn);
        ZoomOutAction zoomOut = new ZoomOutAction(rootEditPart.getZoomManager());
        this.getActionRegistry().registerAction((IAction)zoomOut);
        ContextMenuProvider provider = this.createContextMenuProvider();
        this.getGraphicalViewer().setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu(this.getEditorSite().getId() + ".contextmenu", (MenuManager)provider, (ISelectionProvider)this.getGraphicalViewer());
        this.loadProperties();
        ToggleGridAction showGrid = new ToggleGridAction(this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)showGrid);
        this.getGraphicalViewer().setProperty(DObjSelectionTool.class.getSimpleName(), (Object)((DobjEditDomain)this.getEditDomain()).getDobjSelectionTool());
    }

    protected void initializeGraphicalViewer() {
        this.getGraphicalViewer().setContents(this.model);
    }

    protected void loadProperties() {
        this.getGraphicalViewer().setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
    }

    protected ContextMenuProvider createContextMenuProvider() {
        return new DobjContextMenuProvider((EditPartViewer)this.getGraphicalViewer(), this.getActionRegistry());
    }

    protected abstract EditPartFactory getEditPartFactory();

    protected void configureZoomManager(ZoomManager zoomManager) {
        zoomManager.setZoomAnimationStyle(1);
        zoomManager.setZoomLevelContributions(Arrays.asList(ZoomManager.FIT_ALL, ZoomManager.FIT_HEIGHT, ZoomManager.FIT_WIDTH));
    }

    public void dispose() {
        this.geheOffline();
        if (this.titleImage != null) {
            this.titleImage.dispose();
        }
        this.getGraphicalViewer().setContents(null);
        this.davProvider.removePropertyChangeListener("verbunden", (PropertyChangeListener)this.verbundenPropertyChangeListener);
        super.dispose();
    }

    protected abstract IContentOutlinePage getOutlinePage();

    protected FigureCanvas getEditor() {
        return (FigureCanvas)this.getGraphicalViewer().getControl();
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.sharedKeyHandler;
    }

    protected ZoomManager getZoomManager() {
        return (ZoomManager)this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        Object action = new DirectEditAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new PanAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new RectangleZoomAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new SelectAllAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    public Object getAdapter(Class type) {
        if (type == DobjEditDomain.class) {
            return this.getEditDomain();
        }
        if (type == IContentOutlinePage.class) {
            return this.getOutlinePage();
        }
        if (type == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        if (type == ZoomManager.class) {
            return this.getZoomManager();
        }
        if (type == this.getModelClass()) {
            return this.getModel();
        }
        return super.getAdapter(type);
    }

    protected abstract class OutlinePage
    extends Page
    implements IContentOutlinePage,
    IAdaptable {
        private int maxBufferSize = 25600;
        private SashForm control;
        private TreeViewer viewer;
        private Canvas overview;
        private Thumbnail2 thumbnail;
        private DisposeListener disposeListener;

        protected OutlinePage() {
        }

        public int getMaxBufferSize() {
            return this.maxBufferSize;
        }

        public void setMaxBufferSize(int maxBufferSize) {
            this.maxBufferSize = maxBufferSize;
        }

        public void init(IPageSite pageSite) {
            super.init(pageSite);
            ActionRegistry registry = DobjGraphicalEditor.this.getActionRegistry();
            IActionBars bars = pageSite.getActionBars();
            String id = ActionFactory.UNDO.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.REDO.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.DELETE.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = "org.eclipse.gef.zoom_in";
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = "org.eclipse.gef.zoom_out";
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            bars.updateActionBars();
        }

        public void createControl(Composite parent) {
            this.control = new SashForm(parent, 66048);
            this.control.setBackground(ColorConstants.buttonDarker);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            this.control.setLayout((Layout)layout);
            this.overview = new Canvas((Composite)this.control, 0);
            GridDataFactory.fillDefaults().hint(-1, 150).applyTo((Control)this.overview);
            LightweightSystem lws = new LightweightSystem(this.overview);
            ScalableRootEditPart root = (ScalableRootEditPart)DobjGraphicalEditor.this.getGraphicalViewer().getRootEditPart();
            this.thumbnail = new ScrollableThumbnail2(this.maxBufferSize, (Viewport)root.getFigure());
            this.thumbnail.setBorder((Border)new MarginBorder(3));
            this.thumbnail.setSource(root.getLayer((Object)"Printable Layers"));
            lws.setContents((IFigure)this.thumbnail);
            this.disposeListener = e -> {
                if (this.thumbnail != null) {
                    this.thumbnail.deactivate();
                    this.thumbnail = null;
                }
            };
            DobjGraphicalEditor.this.getEditor().addDisposeListener(this.disposeListener);
            this.viewer = new TreeViewer();
            this.getTreeViewer().createControl((Composite)this.control);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.viewer.getControl());
            this.configureOutlineViewer();
            this.hookOutlineViewer();
            this.initializeOutlineViewer();
            this.control.setWeights(new int[]{30, 70});
        }

        public void dispose() {
            this.unhookOutlineViewer();
            if (this.thumbnail != null) {
                this.thumbnail.deactivate();
                this.thumbnail = null;
            }
            super.dispose();
        }

        protected void hookOutlineViewer() {
            DobjGraphicalEditor.this.getSelectionSynchronizer().addViewer((EditPartViewer)this.getTreeViewer());
        }

        protected void unhookOutlineViewer() {
            DobjGraphicalEditor.this.getSelectionSynchronizer().removeViewer((EditPartViewer)this.getTreeViewer());
            if (this.disposeListener != null && DobjGraphicalEditor.this.getEditor() != null && !DobjGraphicalEditor.this.getEditor().isDisposed()) {
                DobjGraphicalEditor.this.getEditor().removeDisposeListener(this.disposeListener);
            }
        }

        protected void configureOutlineViewer() {
            this.getTreeViewer().setEditDomain((EditDomain)DobjGraphicalEditor.this.getEditDomain());
            this.getTreeViewer().setEditPartFactory(this.getEditPartFactory());
            ContextMenuProvider provider = this.createContextMenuProvider();
            this.getTreeViewer().setContextMenu((MenuManager)provider);
            this.getSite().registerContextMenu(DobjGraphicalEditor.this.getEditorSite().getId() + ".contextmenu", (MenuManager)provider, this.getSite().getSelectionProvider());
            this.getTreeViewer().setKeyHandler(DobjGraphicalEditor.this.getCommonKeyHandler());
            this.getTreeViewer().addDropTargetListener((TransferDropTargetListener)new TemplateTransferDropTargetListener((EditPartViewer)this.getTreeViewer()));
        }

        protected void initializeOutlineViewer() {
            this.setContents(DobjGraphicalEditor.this.getModel());
            TreeItem[] treeItemArray = this.viewer.getControl().getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                item.setExpanded(true);
                TreeItem[] treeItemArray2 = item.getItems();
                int n3 = treeItemArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem subItem = treeItemArray2[n4];
                    subItem.setExpanded(true);
                    ++n4;
                }
                ++n2;
            }
        }

        protected void setContents(Object contents) {
            this.getTreeViewer().setContents(contents);
        }

        public Control getControl() {
            return this.control;
        }

        public void setFocus() {
            this.viewer.getControl().setFocus();
        }

        protected TreeViewer getTreeViewer() {
            return this.viewer;
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.getTreeViewer().addSelectionChangedListener(listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.getTreeViewer().removeSelectionChangedListener(listener);
        }

        public ISelection getSelection() {
            if (this.getTreeViewer() == null) {
                return StructuredSelection.EMPTY;
            }
            return this.getTreeViewer().getSelection();
        }

        public void setSelection(ISelection selection) {
            if (this.getTreeViewer() != null) {
                this.getTreeViewer().setSelection(selection);
            }
        }

        protected abstract EditPartFactory getEditPartFactory();

        protected ContextMenuProvider createContextMenuProvider() {
            return new DobjContextMenuProvider((EditPartViewer)this.getTreeViewer(), DobjGraphicalEditor.this.getActionRegistry());
        }

        public Object getAdapter(Class type) {
            if (type == DobjEditDomain.class) {
                return DobjGraphicalEditor.this.getEditDomain();
            }
            if (type == TreeViewer.class) {
                return this.getTreeViewer();
            }
            if (type == ZoomManager.class) {
                return DobjGraphicalEditor.this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
            }
            if (type == DobjGraphicalEditor.this.getModelClass()) {
                return DobjGraphicalEditor.this.getModel();
            }
            return null;
        }
    }

    private final class VerbundenPropertyChangeListener
    implements PropertyChangeListener {
        private VerbundenPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DobjGraphicalEditor.this.online = (Boolean)evt.getNewValue();
            DobjGraphicalEditor.this.updateOnline();
        }
    }
}

