/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.editors;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import de.bsvrz.buv.plugin.dobj.actions.CopyDobjAction;
import de.bsvrz.buv.plugin.dobj.actions.PasteDobjAction;
import de.bsvrz.buv.plugin.dobj.editors.DobjEditorContextMenuProvider;
import de.bsvrz.buv.plugin.dobj.editors.DobjGraphicalEditor;
import de.bsvrz.buv.plugin.dobj.editors.Splitter;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.MatchHeightAction;
import org.eclipse.gef.ui.actions.MatchWidthAction;
import org.eclipse.gef.ui.actions.ToggleRulerVisibilityAction;
import org.eclipse.gef.ui.actions.ToggleSnapToGeometryAction;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.rulers.RulerComposite;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public abstract class DobjGraphicalEditorWithPalette<T extends Named>
extends DobjGraphicalEditor<T> {
    private static final int PALETTE_SIZE = 200;
    private PaletteViewer paletteViewer;
    private RulerComposite rulerContainer;

    protected DobjGraphicalEditorWithPalette(Class<T> modelClass) {
        super(modelClass);
    }

    @Override
    protected void createGraphicalViewer(Composite parent) {
        this.rulerContainer = new RulerComposite(parent, 0);
        super.createGraphicalViewer((Composite)this.rulerContainer);
        this.rulerContainer.setGraphicalViewer((ScrollingGraphicalViewer)this.getGraphicalViewer());
    }

    @Override
    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new TemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
        CopyDobjAction copy = (CopyDobjAction)this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId());
        this.getGraphicalViewer().addSelectionChangedListener((ISelectionChangedListener)copy);
    }

    protected void configurePaletteViewer() {
    }

    @Override
    protected ContextMenuProvider createContextMenuProvider() {
        return new DobjEditorContextMenuProvider((EditPartViewer)this.getGraphicalViewer(), this.getActionRegistry());
    }

    protected void createPaletteViewer(Composite parent) {
        PaletteViewer viewer = new PaletteViewer();
        this.setPaletteViewer(viewer);
        viewer.createControl(parent);
        this.configurePaletteViewer();
        this.hookPaletteViewer();
        this.initializePaletteViewer();
    }

    public void createPartControl(Composite parent) {
        Splitter splitter = new Splitter(parent, 256);
        this.createPaletteViewer(splitter);
        this.createGraphicalViewer(splitter);
        splitter.maintainSize(this.getPaletteViewer().getControl());
        splitter.setFixedSize(this.getInitialPaletteSize());
        splitter.addFixedSizeChangeListener(evt -> this.handlePaletteResized(((Splitter)((Object)((Object)evt.getSource()))).getFixedSize()));
    }

    protected abstract PaletteRoot getPaletteRoot();

    protected int getInitialPaletteSize() {
        return 200;
    }

    protected PaletteViewer getPaletteViewer() {
        return this.paletteViewer;
    }

    protected void handlePaletteResized(int newSize) {
    }

    protected void hookPaletteViewer() {
        this.getEditDomain().setPaletteViewer(this.paletteViewer);
    }

    protected void initializePaletteViewer() {
        this.getPaletteViewer().addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)this.getPaletteViewer()));
    }

    protected void setPaletteViewer(PaletteViewer paletteViewer) {
        this.paletteViewer = paletteViewer;
    }

    protected void setEditDomain(DefaultEditDomain ed) {
        super.setEditDomain(ed);
        this.getEditDomain().setPaletteRoot(this.getPaletteRoot());
    }

    @Override
    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        Object action = new CopyDobjAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new PasteDobjAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 1);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 4);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 8);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 32);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 2);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 16);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new MatchWidthAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new MatchHeightAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
    }

    @Override
    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        ToggleRulerVisibilityAction showRulers = new ToggleRulerVisibilityAction(this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)showRulers);
        ToggleSnapToGeometryAction snapAction = new ToggleSnapToGeometryAction(this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)snapAction);
    }

    @Override
    protected void loadProperties() {
        super.loadProperties();
        this.getGraphicalViewer().setProperty("SnapToGeometry.isEnabled", (Object)Boolean.TRUE);
        this.getGraphicalViewer().setProperty("SnapToGrid.isEnabled", (Object)Boolean.FALSE);
        this.getGraphicalViewer().setProperty("SnapToGrid.isVisible", (Object)Boolean.FALSE);
    }
}

