/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.editparts;

import de.bsvrz.buv.plugin.dobj.editparts.GeoRefererenzObjektEditPart;
import de.bsvrz.buv.plugin.dobj.util.Projektion;
import de.bsvrz.sys.funclib.bitctrl.geolib.WGS84Koordinate;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdKomplexKoordinaten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Flaeche;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Komplex;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.KomplexXY;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Linie;
import de.bsvrz.sys.funclib.bitctrl.modell.util.geolib.WGS84Util;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;

public abstract class KomplexEditPart<T extends Komplex, F extends IFigure>
extends GeoRefererenzObjektEditPart<T, F> {
    private static final Debug LOGGER = Debug.getLogger();
    private List<PointList> flaechen;
    private List<PointList> linien;

    @Override
    protected void cleanModellKoordinaten() {
        this.flaechen = null;
    }

    protected List<PointList> getFlaechen() {
        if (this.flaechen == null) {
            Projektion aktuelleProjektion = this.getProjektion();
            KomplexXY komplex = (KomplexXY)this.getSystemObjekt();
            try {
                this.flaechen = new ArrayList<PointList>();
                KdKomplexKoordinaten.Daten datum = (KdKomplexKoordinaten.Daten)komplex.getKdKomplexKoordinaten().getDatum();
                if (datum != null) {
                    for (Flaeche flaeche : datum.getFlaechenReferenz()) {
                        PointList points = new PointList();
                        for (WGS84Koordinate k : WGS84Util.konvertiere((Flaeche)flaeche)) {
                            Point p = aktuelleProjektion.umrechnenWeltNachModel((Point)new PrecisionPoint(k.getLaenge(), k.getBreite()));
                            points.addPoint(p);
                        }
                        this.flaechen.add(points);
                    }
                }
            }
            catch (RuntimeException ex) {
                LOGGER.error("Die WGS-84-Koordinaten des Komplex konnten nicht bestimmt werden: " + String.valueOf(komplex), (Throwable)ex);
            }
        }
        return this.flaechen;
    }

    protected List<PointList> getLinien() {
        if (this.linien == null) {
            Projektion aktuelleProjektion = this.getProjektion();
            KomplexXY komplex = (KomplexXY)this.getSystemObjekt();
            try {
                this.linien = new ArrayList<PointList>();
                KdKomplexKoordinaten.Daten datum = (KdKomplexKoordinaten.Daten)komplex.getKdKomplexKoordinaten().getDatum();
                if (datum != null) {
                    for (Linie linie : datum.getLinienReferenz()) {
                        PointList points = new PointList();
                        for (WGS84Koordinate k : WGS84Util.konvertiere((Linie)linie)) {
                            Point p = aktuelleProjektion.umrechnenWeltNachModel((Point)new PrecisionPoint(k.getLaenge(), k.getBreite()));
                            points.addPoint(p);
                        }
                        this.linien.add(points);
                    }
                }
            }
            catch (RuntimeException ex) {
                LOGGER.error("Die WGS-84-Koordinaten des Komplex konnten nicht bestimmt werden: " + String.valueOf(komplex), (Throwable)ex);
            }
        }
        return this.linien;
    }
}

