/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.editparts;

import de.bsvrz.buv.plugin.dobj.editparts.GeoRefererenzObjektEditPart;
import de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel;
import de.bsvrz.buv.plugin.dobj.util.Projektion;
import de.bsvrz.sys.funclib.bitctrl.geolib.WGS84Koordinate;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.GeoReferenzObjekt;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbstractPointListShape;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;

public abstract class PunktlisteEditPart<T extends GeoReferenzObjekt, F extends AbstractPointListShape>
extends GeoRefererenzObjektEditPart<T, F> {
    private List<Point> wgs84Points;
    private PointList points;

    @Override
    protected void cleanModellKoordinaten() {
        this.points = null;
    }

    protected List<Point> getWgs84Points() {
        if (this.wgs84Points == null) {
            List<WGS84Koordinate> koordinaten = this.doGetWgs84Koordinaten();
            this.wgs84Points = new ArrayList<Point>();
            for (WGS84Koordinate p : koordinaten) {
                this.wgs84Points.add((Point)new PrecisionPoint(p.getLaenge(), p.getBreite()));
            }
        }
        return this.wgs84Points;
    }

    protected abstract List<WGS84Koordinate> doGetWgs84Koordinaten();

    public PointList getPoints() {
        if (this.points == null) {
            this.points = new PointList();
            Projektion aktuelleProjektion = this.getProjektion();
            for (Point p : this.getWgs84Points()) {
                this.points.addPoint(aktuelleProjektion.umrechnenWeltNachModel((Point)new PrecisionPoint(p.preciseX(), p.preciseY())));
            }
        }
        return this.points;
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        if (((BitCtrlDoModel)this.getModel()).getSystemObject() != null && ((BitCtrlDoModel)this.getModel()).getLocation() == null && this.getProjektion() != null) {
            IFigure f = this.getFigure();
            ((AbstractPointListShape)this.getFigure()).setPoints(this.getPoints());
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, f, (Object)f.getBounds());
        }
    }
}

