/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.editparts;

import de.bsvrz.buv.plugin.darstellung.editparts.EbeneEditPart;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienStyle;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.Verbindungslinie;
import de.bsvrz.buv.plugin.dobj.requests.VerbindungslinieRequest;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.zoom.ZoomListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class VerbindungslinieEditPart
extends AbstractConnectionEditPart
implements ZoomListener {
    private final Adapter darstellungAdapter = new DarstellungAdapter();
    private final Adapter verbindungslinieAdapter = new VerbindunglinienAdapter();
    private boolean verbindungslinieSichtbar = true;
    private IFigure ebenenFigure;

    protected IFigure createFigure() {
        return new VerbindungslinieFigure();
    }

    public PolylineConnection getFigure() {
        return (PolylineConnection)super.getFigure();
    }

    public Verbindungslinie getModel() {
        return (Verbindungslinie)super.getModel();
    }

    protected void activateFigure() {
        this.ebenenFigure = this.findLayer();
        if (this.getFigure().getParent() != this.ebenenFigure) {
            this.ebenenFigure.add((IFigure)this.getFigure(), -1);
        }
    }

    private IFigure findLayer() {
        EditPart editPart;
        EditPart editPart2;
        IFigure result = this.getLayer("Connection Layer");
        EbeneEditPart targetParent = null;
        EbeneEditPart sourceParent = null;
        if (this.getTarget() != null && (editPart2 = this.getTarget().getParent()) instanceof EbeneEditPart) {
            EbeneEditPart ebenePart;
            targetParent = ebenePart = (EbeneEditPart)editPart2;
            targetParent.getContentPane().add((IFigure)this.getFigure());
        }
        if (this.getSource() != null && (editPart = this.getSource().getParent()) instanceof EbeneEditPart) {
            EbeneEditPart ebenePart;
            sourceParent = ebenePart = (EbeneEditPart)editPart;
        }
        if (targetParent != null) {
            result = targetParent.getContentPane();
        } else if (sourceParent != null) {
            result = sourceParent.getContentPane();
        }
        return result;
    }

    protected void deactivateFigure() {
        this.ebenenFigure.remove((IFigure)this.getFigure());
        this.getConnectionFigure().setSourceAnchor(null);
        this.getConnectionFigure().setTargetAnchor(null);
    }

    protected void createEditPolicies() {
    }

    public boolean isSelectable() {
        return false;
    }

    public void activate() {
        super.activate();
        Darstellung d = this.getDarstellung();
        if (d != null) {
            d.eAdapters().add((Object)this.darstellungAdapter);
        }
        this.getModel().eAdapters().add((Object)this.verbindungslinieAdapter);
        this.getZoomManager().addZoomListener((ZoomListener)this);
    }

    private Darstellung getDarstellung() {
        return (Darstellung)this.getViewer().getProperty(Darstellung.class.toString());
    }

    private ZoomManager getZoomManager() {
        return (ZoomManager)this.getViewer().getProperty(ZoomManager.class.toString());
    }

    public void deactivate() {
        this.getZoomManager().removeZoomListener((ZoomListener)this);
        this.getModel().eAdapters().remove((Object)this.verbindungslinieAdapter);
        Darstellung d = this.getDarstellung();
        if (d != null) {
            d.eAdapters().remove((Object)this.darstellungAdapter);
        }
        super.deactivate();
    }

    public void zoomChanged(double zoom) {
        this.refreshLinienstaerke();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshVisibility();
        this.refreshLinienfarbe();
        this.refreshLinienstaerke();
        this.refreshLinienstil();
    }

    private void refreshVisibility() {
        Darstellung d = this.getDarstellung();
        PolylineConnection f = this.getFigure();
        Ebene quelleEbene = null;
        DarstellungsSpalte quelleSpalte = null;
        Ebene zielEbene = null;
        DarstellungsSpalte zielSpalte = null;
        DoModel quelle = this.getModel().getQuelle();
        DoModel ziel = this.getModel().getZiel();
        for (Ebene e : d.getEbenen()) {
            if (e.getDoObjekte().contains((Object)quelle)) {
                quelleEbene = e;
            }
            if (!e.getDoObjekte().contains((Object)ziel)) continue;
            zielEbene = e;
        }
        if (d instanceof StilisierteDarstellung) {
            StilisierteDarstellung sd = (StilisierteDarstellung)d;
            for (DarstellungsSpalte s : sd.getSpalten()) {
                if (s.getDoObjekte().contains((Object)quelle)) {
                    quelleSpalte = s;
                }
                if (!s.getDoObjekte().contains((Object)ziel)) continue;
                zielSpalte = s;
            }
        }
        boolean quelleIsVisible = quelleEbene != null && quelleEbene.isVisible() && (quelleSpalte == null || quelleSpalte.isVisible());
        boolean zielIsVisible = zielEbene != null && zielEbene.isVisible() && (zielSpalte == null || zielSpalte.isVisible());
        f.setVisible(this.verbindungslinieSichtbar && quelleIsVisible && zielIsVisible);
    }

    private void refreshLinienstaerke() {
        Darstellung d = this.getDarstellung();
        PolylineConnection f = this.getFigure();
        double normalizedLineWidth = (double)d.getVerbindungslinieStaerke() / this.getZoomManager().getZoom();
        f.setLineWidthFloat((float)normalizedLineWidth);
    }

    private void refreshLinienfarbe() {
        Darstellung d = this.getDarstellung();
        PolylineConnection f = this.getFigure();
        RGB rgb = d.getVerbindungslinieFarbe();
        Color color = this.getViewer().getResourceManager().createColor(rgb);
        f.setForegroundColor(color);
    }

    private void refreshLinienstil() {
        Darstellung d = this.getDarstellung();
        PolylineConnection f = this.getFigure();
        LinienStyle stil = d.getVerbindungslinieStil();
        switch (stil) {
            case DURCHGEZOGEN: {
                f.setLineStyle(1);
                break;
            }
            case PUNKT: {
                f.setLineStyle(3);
                break;
            }
            case STRICH: {
                f.setLineStyle(2);
                break;
            }
            case STRICH_PUNKT: {
                f.setLineStyle(4);
                break;
            }
            case STRICH_PUNKT_PUNKT: {
                f.setLineStyle(5);
                break;
            }
            default: {
                throw new IllegalStateException("Unbekannter Enum-Wert f\u00fcr " + String.valueOf(LinienStyle.class) + ": " + String.valueOf((Object)stil));
            }
        }
    }

    public void performRequest(Request req) {
        super.performRequest(req);
        if ("Verbindungslinie".equals(req.getType())) {
            VerbindungslinieRequest vlr = (VerbindungslinieRequest)req;
            this.verbindungslinieSichtbar = vlr.isVerbindungsLinie();
            this.refreshVisibility();
        }
    }

    private final class DarstellungAdapter
    extends EContentAdapter {
        private DarstellungAdapter() {
        }

        public void notifyChanged(Notification msg) {
            this.handleDarstellung(msg);
            this.handleEbene(msg);
            this.handleDarstellungsspalte(msg);
        }

        private void handleDarstellung(Notification msg) {
            if (msg.getNotifier() instanceof Darstellung) {
                block0 : switch (msg.getEventType()) {
                    case 1: 
                    case 2: {
                        switch (msg.getFeatureID(Darstellung.class)) {
                            case 8: {
                                VerbindungslinieEditPart.this.refreshLinienfarbe();
                                break block0;
                            }
                            case 9: {
                                VerbindungslinieEditPart.this.refreshLinienstaerke();
                                break block0;
                            }
                            case 10: {
                                VerbindungslinieEditPart.this.refreshLinienstil();
                                break block0;
                            }
                        }
                        break;
                    }
                }
            }
        }

        private void handleEbene(Notification msg) {
            if (msg.getNotifier() instanceof Ebene) {
                block0 : switch (msg.getEventType()) {
                    case 1: 
                    case 2: {
                        switch (msg.getFeatureID(Darstellung.class)) {
                            case 1: {
                                VerbindungslinieEditPart.this.refreshVisibility();
                                break block0;
                            }
                        }
                        break;
                    }
                }
            }
        }

        private void handleDarstellungsspalte(Notification msg) {
            if (msg.getNotifier() instanceof DarstellungsSpalte) {
                block0 : switch (msg.getEventType()) {
                    case 1: 
                    case 2: {
                        switch (msg.getFeatureID(Darstellung.class)) {
                            case 1: {
                                VerbindungslinieEditPart.this.refreshVisibility();
                                break block0;
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    private final class VerbindunglinienAdapter
    extends EContentAdapter {
        private VerbindunglinienAdapter() {
        }

        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            if (msg.getNotifier() instanceof Verbindungslinie) {
                block0 : switch (msg.getEventType()) {
                    case 1: 
                    case 2: {
                        switch (msg.getFeatureID(Verbindungslinie.class)) {
                            case 0: 
                            case 1: {
                                VerbindungslinieEditPart.this.refreshVisibility();
                                break block0;
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    private static final class VerbindungslinieFigure
    extends PolylineConnection {
        private VerbindungslinieFigure() {
        }
    }
}

