/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.figures;

import com.bitctrl.lib.eclipse.draw2d.svg.SVGCache;
import com.bitctrl.lib.eclipse.draw2d.svg.SVGFigure;
import de.bsvrz.buv.plugin.dobj.DoFigure;
import de.bsvrz.buv.plugin.dobj.decorator.ZoomVerhaltenFixFigure;
import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.plugin.dobj.util.BildManager;
import de.bsvrz.sys.funclib.bitctrl.modell.att.Feld;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.konfigurationsdaten.KdBild;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.Bild;
import de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class DoBildFigure
extends Figure
implements DoFigure,
ZoomVerhaltenFixFigure {
    private Bild bild;
    private Image image;
    private boolean zoomVerhaltenFix;
    private int hoehe;
    private int breite;
    private double zoom;
    private Point hotspot = new Point();
    private double vonZoom;
    private double bisZoom;
    private final ResourceManager resourceManager;

    public DoBildFigure(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public final Bild getBild() {
        return this.bild;
    }

    private void refreshBild() {
        block23: {
            if (this.image != null && !this.image.isDisposed()) {
                this.image.dispose();
                this.image = null;
            }
            this.setVisible(this.vonZoom <= this.zoom && this.zoom <= this.bisZoom);
            if (this.zoomVerhaltenFix) {
                bound = new Rectangle(this.hotspot, new PrecisionDimension((double)this.breite, (double)this.hoehe).getScaled(1.0 / this.zoom));
                this.setBounds(bound);
            } else {
                bound = new Rectangle(this.hotspot, (Dimension)new PrecisionDimension((double)this.breite, (double)this.hoehe));
                this.setBounds(bound);
            }
            if (this.bild != null) {
                if ("image/svg+xml".equalsIgnoreCase(((KdBild.Daten)this.bild.getKdBild().getDatum()).getMIMEType())) {
                    Feld bilddaten = ((KdBild.Daten)this.bild.getKdBild().getDatum()).getBilddaten();
                    byte[] buffer = new byte[bilddaten.size()];
                    int i = 0;
                    while (i < bilddaten.size()) {
                        buffer[i] = ((AttByte_JavaKeyword)bilddaten.get(i)).byteValue();
                        ++i;
                    }
                    File file = DObjPlugin.getDefault().getBundle().getBundleContext().getDataFile(this.bild.getPid() + System.currentTimeMillis() + ".tmp");
                    try {
                        try {
                            Throwable throwable = null;
                            Object var5_10 = null;
                            try (FileOutputStream fout = new FileOutputStream(file);){
                                fout.write(buffer);
                                fout.flush();
                                SVGCache svg = new SVGCache();
                                svg.setURI(file.toURI().toString(), true);
                                this.removeAll();
                                SVGFigure svgFigure = new SVGFigure();
                                svgFigure.setSize(this.breite, this.hoehe);
                                svgFigure.setSvgCache(svg);
                                this.add((IFigure)svgFigure);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException ex) {
                            DObjPlugin.getDefault().getLog().error("Laden eines SVG Hintergrundbildes ist fehlgeschlagen.", (Throwable)ex);
                            SafeRunner.run(() -> Files.deleteIfExists(file.toPath()));
                            break block23;
                        }
                    }
                    catch (Throwable throwable) {
                        SafeRunner.run(() -> Files.deleteIfExists(file.toPath()));
                        throw throwable;
                    }
                    SafeRunner.run(() -> Files.deleteIfExists(file.toPath()));
                } else {
                    ImageDescriptor desc = BildManager.INSTANCE.getImageDescriptor(this.bild);
                    try {
                        ImageData data = desc.getImageData().scaledTo(this.breite, this.hoehe);
                        this.image = this.resourceManager.createImageWithDefault(ImageDescriptor.createFromImageData((ImageData)data));
                    }
                    catch (NegativeArraySizeException ex) {
                        this.image = (Image)this.resourceManager.create((DeviceResourceDescriptor)desc);
                    }
                    this.removeAll();
                    ImageFigure imgFigure = new ImageFigure(this.image);
                    imgFigure.setSize(this.breite, this.hoehe);
                    this.add((IFigure)imgFigure);
                }
            }
        }
    }

    protected final void paintChildren(Graphics graphics) {
        graphics.setAdvanced(true);
        graphics.setAntialias(1);
        if (this.zoom != 1.0 && this.isZoomVerhaltenFix()) {
            graphics.scale(1.0 / this.zoom);
            graphics.pushState();
            super.paintChildren(graphics);
            graphics.popState();
        } else {
            super.paintChildren(graphics);
        }
    }

    public final void setBild(Bild bild) {
        if (this.bild != null && this.bild.equals(bild) || this.bild == null && bild == null) {
            return;
        }
        this.bild = bild;
        this.refreshBild();
    }

    @Override
    public void handleZoomChanged(double newZoom) {
        if (this.zoom == newZoom) {
            return;
        }
        this.zoom = newZoom;
        this.refreshBild();
    }

    public void setSize(int w, int h) {
        this.hoehe = h;
        this.breite = w;
        this.refreshBild();
    }

    @Override
    public boolean isZoomVerhaltenFix() {
        return this.zoomVerhaltenFix;
    }

    @Override
    public void setZoomVerhaltenFix(boolean zoomVerhaltenFix) {
        if (this.zoomVerhaltenFix != zoomVerhaltenFix) {
            this.zoomVerhaltenFix = zoomVerhaltenFix;
            this.refreshBild();
        }
    }

    @Override
    public Point getHotspot() {
        return this.hotspot;
    }

    @Override
    public void setHotspot(Point hotspot) {
        if (this.hotspot != null && this.hotspot.equals((Object)hotspot)) {
            return;
        }
        this.hotspot = hotspot;
        this.refreshBild();
    }

    @Override
    public void setSichtbareZoomStufe(double vonZoom, double bisZoom) {
        if (this.vonZoom == vonZoom && this.bisZoom == bisZoom) {
            return;
        }
        this.vonZoom = vonZoom;
        this.bisZoom = bisZoom;
        this.refreshBild();
    }

    protected boolean useLocalCoordinates() {
        return true;
    }
}

