/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.figures;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Font;

public class DoTextFigure
extends Figure {
    private boolean zoomVerhaltenFix = true;
    private double zoom = 1.0;
    private String text = "";
    private Dimension calculateTextSize = new Dimension();

    public boolean isZoomVerhaltenFix() {
        return this.zoomVerhaltenFix;
    }

    public void setZoomVerhaltenFix(boolean zoomVerhaltenFix) {
        if (this.zoomVerhaltenFix == zoomVerhaltenFix) {
            return;
        }
        this.zoomVerhaltenFix = zoomVerhaltenFix;
        this.updateSize();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (this.text.equals(text)) {
            return;
        }
        this.text = text != null ? text : "";
        this.updateSize();
        this.repaint();
    }

    private void updateSize() {
        if (this.getFont() == null) {
            return;
        }
        this.calculateTextSize = TextUtilities.INSTANCE.getTextExtents(this.getText(), this.getFont());
        if (this.zoomVerhaltenFix) {
            Dimension size = this.calculateTextSize;
            this.setSize((int)((double)size.width / this.zoom), (int)((double)size.height / this.zoom));
        } else {
            this.setSize(this.calculateTextSize);
        }
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.updateSize();
        this.repaint();
    }

    public void handleZoomChanged(double newZoom) {
        if (this.zoom == newZoom) {
            return;
        }
        this.zoom = newZoom;
        this.updateSize();
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.isZoomVerhaltenFix() && graphics instanceof ScaledGraphics) {
            Point p = this.getLocation();
            graphics.translate(p);
            graphics.scale(1.0 / this.zoom);
            graphics.drawText(this.getText(), 0, 0);
            graphics.translate(p.getNegated());
        } else {
            graphics.drawText(this.getText(), this.getLocation());
        }
    }
}

