/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.figures;

import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.dobj.preferences.DobjPreference;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Panel;

public class SystemObjectToolTipFigure
extends Panel {
    private Label customNameLabel;
    private final Label nameLabel;
    private Label pidLabel;
    private Label kurzinfoLabel;
    private Label beschreibungLabel;
    private boolean infoRead;
    private String info;
    private String desc;

    public SystemObjectToolTipFigure() {
        this(null);
    }

    public SystemObjectToolTipFigure(SystemObject so) {
        this.setLayoutManager((LayoutManager)new GridLayout());
        this.nameLabel = new Label();
        this.add((IFigure)this.nameLabel);
        this.setSystemObject(so);
    }

    public void setSystemObject(SystemObject systemObject) {
        this.infoRead = false;
        if (systemObject == null) {
            this.nameLabel.setText("Kein Systemobjekt gesetzt.");
            if (this.pidLabel != null) {
                this.remove((IFigure)this.pidLabel);
                this.pidLabel = null;
            }
            if (this.kurzinfoLabel != null) {
                this.remove((IFigure)this.kurzinfoLabel);
                this.kurzinfoLabel = null;
            }
            if (this.beschreibungLabel != null) {
                this.remove((IFigure)this.beschreibungLabel);
                this.beschreibungLabel = null;
            }
        } else {
            String defaultFormat = DObjPlugin.getDefault().getPreferenceStore().getString(DobjPreference.TOOLTIP_FORMAT.getId());
            if (defaultFormat == null || defaultFormat.trim().isEmpty()) {
                defaultFormat = RahmenwerkService.getService().getRahmenWerk().getRahmenwerkProductProperties().getDefaultDobjTooltipPattern();
            }
            if (defaultFormat != null && !defaultFormat.trim().isEmpty()) {
                this.formatTooltip(systemObject, defaultFormat);
                return;
            }
            this.nameLabel.setText(systemObject.getName());
            if (this.pidLabel == null) {
                this.pidLabel = new Label();
                this.add((IFigure)this.pidLabel);
            }
            this.pidLabel.setText("(PID: " + systemObject.getPid() + ")");
            AttributeGroup atg = systemObject.getDataModel().getAttributeGroup("atg.info");
            Data data = systemObject.getConfigurationData(atg);
            if (data != null) {
                String beschreibung;
                String kurzinfo = data.getTextValue("kurzinfo").getText();
                if (!kurzinfo.isEmpty()) {
                    if (this.kurzinfoLabel == null) {
                        this.kurzinfoLabel = new Label();
                        this.add((IFigure)this.kurzinfoLabel);
                    }
                    this.kurzinfoLabel.setText(kurzinfo);
                }
                if (!(beschreibung = data.getTextValue("beschreibung").getText()).isEmpty()) {
                    if (this.beschreibungLabel == null) {
                        this.beschreibungLabel = new Label();
                        this.add((IFigure)this.beschreibungLabel);
                    }
                    this.beschreibungLabel.setText(beschreibung);
                }
            }
        }
    }

    private void formatTooltip(SystemObject systemObject, String formatStr) {
        String tooltipStr = formatStr;
        TooltipPlaceholders[] tooltipPlaceholdersArray = TooltipPlaceholders.values();
        int n = tooltipPlaceholdersArray.length;
        int n2 = 0;
        while (n2 < n) {
            TooltipPlaceholders item = tooltipPlaceholdersArray[n2];
            if (tooltipStr.contains(item.id)) {
                Object replacement;
                switch (item) {
                    case DESC: {
                        replacement = this.getDesc(systemObject);
                        if (replacement != null) break;
                        replacement = "";
                        break;
                    }
                    case INFO: {
                        replacement = this.getInfo(systemObject);
                        if (replacement != null) break;
                        replacement = "";
                        break;
                    }
                    case NAME: {
                        replacement = systemObject.getNameOrPidOrId();
                        if (replacement != null) break;
                        replacement = "";
                        break;
                    }
                    case NEWLINE: {
                        replacement = "\n";
                        break;
                    }
                    case NL_DESC: {
                        replacement = this.getDesc(systemObject);
                        if (replacement != null) {
                            replacement = "\n" + (String)replacement;
                            break;
                        }
                        replacement = "";
                        break;
                    }
                    case NL_INFO: {
                        replacement = this.getInfo(systemObject);
                        if (replacement != null) {
                            replacement = "\n" + (String)replacement;
                            break;
                        }
                        replacement = "";
                        break;
                    }
                    case PID: {
                        replacement = systemObject.getPid();
                        if (replacement != null) break;
                        replacement = "";
                        break;
                    }
                    default: {
                        replacement = null;
                    }
                }
                if (replacement != null) {
                    while (tooltipStr.contains(item.id)) {
                        tooltipStr = tooltipStr.replace(item.id, (CharSequence)replacement);
                    }
                }
            }
            ++n2;
        }
        this.nameLabel.setText(tooltipStr);
    }

    private String getInfo(SystemObject systemObject) {
        this.readInfo(systemObject);
        return this.info;
    }

    private String getDesc(SystemObject systemObject) {
        this.readInfo(systemObject);
        return this.desc;
    }

    private void readInfo(SystemObject systemObject) {
        if (this.infoRead) {
            return;
        }
        AttributeGroup atg = systemObject.getDataModel().getAttributeGroup("atg.info");
        Data data = systemObject.getConfigurationData(atg);
        this.infoRead = true;
        this.info = null;
        this.desc = null;
        if (data != null) {
            String beschreibung;
            String kurzinfo = data.getTextValue("kurzinfo").getText();
            if (!kurzinfo.isEmpty()) {
                this.info = kurzinfo;
            }
            if (!(beschreibung = data.getTextValue("beschreibung").getText()).isEmpty()) {
                this.desc = beschreibung;
            }
        }
    }

    public void setName(String name) {
        if (name != null && !name.isEmpty()) {
            if (this.customNameLabel == null) {
                this.customNameLabel = new Label();
                this.add((IFigure)this.customNameLabel, 0);
            }
            this.customNameLabel.setText(name);
        } else if (this.customNameLabel != null) {
            this.remove((IFigure)this.customNameLabel);
            this.customNameLabel = null;
        }
    }

    public static enum TooltipPlaceholders {
        NAME("{name}"),
        PID("{pid}"),
        INFO("{info}"),
        NL_INFO("{nlinfo}"),
        DESC("{desc}"),
        NL_DESC("{nldesc}"),
        NEWLINE("{nl}");

        private final String id;

        private TooltipPlaceholders(String id) {
            this.id = id;
        }
    }
}

