/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.model.util;

import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class ConfiguratedDoTypAdapter
extends AdapterImpl {
    public boolean isAdapterForType(Object type) {
        return type == ConfiguratedDoTyp.class;
    }

    public void notifyChanged(Notification msg) {
        if (msg.getFeature() == DobjPackage.eINSTANCE.getConfiguratedDoTyp_ConfigurationElement()) {
            switch (msg.getEventType()) {
                case 1: 
                case 2: {
                    this.configureDoTyp(msg);
                }
            }
        }
    }

    private void configureDoTyp(Notification msg) {
        ConfiguratedDoTyp doTyp = (ConfiguratedDoTyp)msg.getNotifier();
        IConfigurationElement configurationElement = (IConfigurationElement)msg.getNewValue();
        this.configureDoTypId(doTyp, configurationElement);
        this.configureDoTypName(doTyp, configurationElement);
        this.configureDoTypDescription(doTyp, configurationElement);
        this.configureSystemObjectType(doTyp, configurationElement);
        this.configureDoTypIcon(doTyp, configurationElement);
        this.configureDoTypNurMassstaeblicheDarstellung(doTyp, configurationElement);
    }

    private void configureDoTypId(ConfiguratedDoTyp doTyp, IConfigurationElement configurationElement) {
        String id = configurationElement.getAttribute("id");
        doTyp.setId(id);
    }

    private void configureDoTypName(ConfiguratedDoTyp doTyp, IConfigurationElement configurationElement) {
        String name = configurationElement.getAttribute("name");
        doTyp.setName(name);
    }

    private void configureDoTypDescription(ConfiguratedDoTyp doTyp, IConfigurationElement configurationElement) {
        String description = configurationElement.getAttribute("description");
        if (description != null) {
            doTyp.setDescription(description);
        }
    }

    private void configureSystemObjectType(ConfiguratedDoTyp doTyp, IConfigurationElement configurationElement) {
        String pid = configurationElement.getAttribute("systemObjektTyp");
        RahmenwerkService rahmenwerkService = RahmenwerkService.getService();
        if (pid != null && rahmenwerkService.getRahmenWerk().isOnline()) {
            ClientDavInterface dav = rahmenwerkService.getRahmenWerk().getDavVerbindung();
            SystemObjectType systemObjectType = dav.getDataModel().getType(pid);
            doTyp.setSystemObjectType(systemObjectType);
        }
    }

    private void configureDoTypIcon(ConfiguratedDoTyp doTyp, IConfigurationElement configurationElement) {
        String imagePath = configurationElement.getAttribute("icon");
        if (imagePath != null) {
            IContributor contributor = configurationElement.getContributor();
            Bundle sourceBundle = Platform.getBundle((String)contributor.getName());
            URL url = FileLocator.find((Bundle)sourceBundle, (IPath)new Path(imagePath), null);
            ImageDescriptor icon = ImageDescriptor.createFromURL((URL)url);
            doTyp.setIcon(icon);
        }
    }

    private void configureDoTypNurMassstaeblicheDarstellung(ConfiguratedDoTyp doTyp, IConfigurationElement configurationElement) {
        String nurMassstaeblicheDarstellung = configurationElement.getAttribute("nurMassstaeblicheDarstellung");
        if (nurMassstaeblicheDarstellung != null) {
            doTyp.setNurMassstaeblicheDarstellung(Boolean.valueOf(nurMassstaeblicheDarstellung));
        }
    }
}

