/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.properties;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;
import com.bitctrl.lib.eclipse.emf.gef.model.Located;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;
import de.bsvrz.buv.plugin.dobj.util.DobjIcons;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class LocatedSection
extends AbstractSection<Located> {
    private CLabel xLabel;
    private Spinner xSpinner;
    private CLabel yLabel;
    private Spinner ySpinner;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite container = factory.createFlatFormComposite(parent);
        this.createLocation(container);
    }

    private void createLocation(Composite parent) {
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        final Button resetToDefaultButton = new Button(parent, 2);
        resetToDefaultButton.setToolTipText("Defaultwert f\u00fcr die Position verwenden.");
        Image image = DobjIcons.ActionRestoreDefault.getImageDescriptor().createImage();
        resetToDefaultButton.setImage(image);
        resetToDefaultButton.addDisposeListener(e -> image.dispose());
        FormData data = new FormData();
        data.width = resetToDefaultButton.computeSize((int)-1, (int)-1).x;
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        resetToDefaultButton.setLayoutData((Object)data);
        this.xSpinner = new Spinner(parent, 2048);
        this.xSpinner.setMinimum(Integer.MIN_VALUE);
        this.xSpinner.setMaximum(Integer.MAX_VALUE);
        factory.adapt((Composite)this.xSpinner);
        data = new FormData();
        data.left = new FormAttachment(0, 170);
        data.right = new FormAttachment(50, 0);
        data.top = new FormAttachment((Control)resetToDefaultButton, 0, 0x1000000);
        this.xSpinner.setLayoutData((Object)data);
        this.xLabel = factory.createCLabel(parent, "X-Position:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.xSpinner, -5);
        data.top = new FormAttachment((Control)this.xSpinner, 0, 0x1000000);
        this.xLabel.setLayoutData((Object)data);
        this.ySpinner = new Spinner(parent, 2048);
        this.ySpinner.setMinimum(Integer.MIN_VALUE);
        this.ySpinner.setMaximum(Integer.MAX_VALUE);
        factory.adapt((Composite)this.ySpinner);
        data = new FormData();
        data.left = new FormAttachment((Control)this.xSpinner, 170);
        data.right = new FormAttachment((Control)resetToDefaultButton);
        data.top = new FormAttachment((Control)this.xSpinner, 0, 0x1000000);
        this.ySpinner.setLayoutData((Object)data);
        this.yLabel = factory.createCLabel(parent, "Y-Position:");
        data = new FormData();
        data.left = new FormAttachment(50, 5);
        data.right = new FormAttachment((Control)this.ySpinner, -5);
        data.top = new FormAttachment((Control)this.ySpinner, 0, 0x1000000);
        this.yLabel.setLayoutData((Object)data);
        resetToDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useDefault = resetToDefaultButton.getSelection();
                Point value = useDefault ? null : new Point();
                SetCommand cmd = new SetCommand(LocatedSection.this.getElement(), (EStructuralFeature)GefPackage.Literals.LOCATED__LOCATION, (Object)value);
                LocatedSection.this.getCommandStack().execute((Command)cmd);
                LocatedSection.this.setUseDefault(useDefault);
            }
        });
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point value;
                EAttribute feature = GefPackage.Literals.LOCATED__LOCATION;
                if (e.widget == LocatedSection.this.xSpinner) {
                    value = new Point(LocatedSection.this.xSpinner.getSelection(), ((Located)LocatedSection.this.getElement()).getLocation().y);
                } else if (e.widget == LocatedSection.this.ySpinner) {
                    value = new Point(((Located)LocatedSection.this.getElement()).getLocation().x, LocatedSection.this.ySpinner.getSelection());
                } else {
                    return;
                }
                SetCommand cmd = new SetCommand(LocatedSection.this.getElement(), (EStructuralFeature)feature, (Object)value);
                LocatedSection.this.getCommandStack().execute((Command)cmd);
            }
        };
        this.xSpinner.addSelectionListener((SelectionListener)selectionListener);
        this.ySpinner.addSelectionListener((SelectionListener)selectionListener);
    }

    public void refresh() {
        int y;
        int x;
        Point location = ((Located)this.getElement()).getLocation();
        this.setUseDefault(location == null);
        if (location != null) {
            x = location.x;
            y = location.y;
        } else {
            x = 0;
            y = 0;
        }
        if (x != this.xSpinner.getSelection()) {
            this.xSpinner.setSelection(x);
        }
        if (y != this.ySpinner.getSelection()) {
            this.ySpinner.setSelection(y);
        }
    }

    private void setUseDefault(boolean useDefault) {
        this.xLabel.setEnabled(!useDefault);
        this.xSpinner.setEnabled(!useDefault);
        this.yLabel.setEnabled(!useDefault);
        this.ySpinner.setEnabled(!useDefault);
    }
}

