/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.tools;

import de.bsvrz.buv.plugin.dobj.tools.BaseTool;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.editparts.ZoomManager;

public class PanTool
extends BaseTool {
    private Point startPunkt;

    public PanTool() {
        this.setDefaultCursor(Cursors.HAND);
        this.setUnloadWhenFinished(false);
    }

    protected String getCommandName() {
        return "pan";
    }

    protected boolean handleButtonDown(int button) {
        if (button == 1) {
            ZoomManager zm = this.getZoomManager();
            this.startPunkt = new Point(zm.getViewport().getHorizontalRangeModel().getValue(), zm.getViewport().getVerticalRangeModel().getValue());
        } else {
            this.handleInvalidInput();
        }
        return true;
    }

    protected boolean handleDragInProgress() {
        if (this.startPunkt != null) {
            ZoomManager zm = this.getZoomManager();
            int divX = this.getStartLocation().x - this.getLocation().x;
            int divY = this.getStartLocation().y - this.getLocation().y;
            zm.getViewport().setHorizontalLocation(this.startPunkt.x + divX);
            zm.getViewport().setVerticalLocation(this.startPunkt.y + divY);
        } else {
            this.handleInvalidInput();
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        this.startPunkt = null;
        return true;
    }

    protected boolean handleInvalidInput() {
        this.startPunkt = null;
        return super.handleInvalidInput();
    }
}

