/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.tools;

import de.bsvrz.buv.plugin.dobj.figures.RectangleFeedbackFigure;
import de.bsvrz.buv.plugin.dobj.tools.AbstractDragTool;
import de.bsvrz.buv.plugin.dobj.util.DobjCursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.editparts.ZoomManager;

public class RectangleZoomTool
extends AbstractDragTool {
    private RectangleFeedbackFigure feedbackFigure;

    public RectangleZoomTool() {
        this.setDefaultCursor(DobjCursors.ZoomIn.getCursor());
        this.setUnloadWhenFinished(false);
    }

    protected String getCommandName() {
        return "zoom rectangle";
    }

    protected void handleFinished() {
        ZoomManager zoomManager = this.getZoomManager();
        Rectangle ausschnitt = new Rectangle(this.getStartLocation(), this.getLocation());
        if (ausschnitt.getSize().height > 10 && ausschnitt.getSize().width > 10) {
            PrecisionPoint ursprung = new PrecisionPoint((double)zoomManager.getViewport().getHorizontalRangeModel().getValue() / zoomManager.getZoom() + (double)ausschnitt.getLocation().x / zoomManager.getZoom(), (double)zoomManager.getViewport().getVerticalRangeModel().getValue() / zoomManager.getZoom() + (double)ausschnitt.getLocation().y / zoomManager.getZoom());
            double currentZoom = zoomManager.getZoom();
            double xZoom = currentZoom / (ausschnitt.preciseWidth() / (double)zoomManager.getViewport().getHorizontalRangeModel().getExtent());
            double yZoom = currentZoom / (ausschnitt.preciseHeight() / (double)zoomManager.getViewport().getVerticalRangeModel().getExtent());
            if (Math.abs(currentZoom - xZoom) > Math.abs(currentZoom - yZoom)) {
                zoomManager.setZoom(yZoom);
            } else {
                zoomManager.setZoom(xZoom);
            }
            zoomManager.getViewport().setHorizontalLocation((int)Math.round(ursprung.preciseX() * zoomManager.getZoom()));
            zoomManager.getViewport().setVerticalLocation((int)Math.round(ursprung.preciseY() * zoomManager.getZoom()));
        }
        super.handleFinished();
    }

    private IFigure getFeedbackFigure() {
        if (this.feedbackFigure == null) {
            this.feedbackFigure = new RectangleFeedbackFigure();
            this.addFeedback((IFigure)this.feedbackFigure);
        }
        return this.feedbackFigure;
    }

    @Override
    protected void showFeedback() {
        Rectangle rect = this.getSelectionRectangle().getCopy();
        this.getFeedbackFigure().translateToRelative((Translatable)rect);
        this.getFeedbackFigure().setBounds(rect);
    }

    private Rectangle getSelectionRectangle() {
        return new Rectangle(this.getStartLocation(), this.getLocation());
    }

    @Override
    protected void eraseFeedback() {
        if (this.feedbackFigure != null) {
            this.removeFeedback((IFigure)this.feedbackFigure);
            this.feedbackFigure = null;
        }
    }
}

