/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.util;

import de.bsvrz.buv.plugin.dobj.internal.DarstellungExtensionPoint;
import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.doeditor.model.DoeditorFactory;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoTypReferenz;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class DoTypenUtil {
    private static final Debug LOGGER = Debug.getLogger();

    private DoTypenUtil() {
    }

    public static Collection<DoTyp> getDoTypen() {
        ArrayList<DoTyp> typen = new ArrayList<DoTyp>();
        typen.addAll(DarstellungExtensionPoint.getDoTypen());
        ObjektFactory factory = RahmenwerkService.getService().getObjektFactory();
        List systemObjekte = factory.bestimmeModellobjekte(new String[]{"typ.darstellungsObjektTyp"});
        for (SystemObjekt so : systemObjekte) {
            try {
                EditorDoTypReferenz doTyp = DoeditorFactory.eINSTANCE.createEditorDoTypReferenz();
                doTyp.setSystemObjekt(so);
                typen.add(doTyp);
            }
            catch (IllegalStateException exception) {
                LOGGER.warning("Der DOT: " + so.getName() + " konnte nicht geladen werden!: " + exception.getLocalizedMessage());
            }
        }
        return typen;
    }

    public static Collection<DoTyp> getDoTypenWithExactMatch(SystemObjectType systemObjectType) {
        if (systemObjectType == null) {
            throw new IllegalArgumentException("Argument darf nicht null sein.");
        }
        ArrayList<DoTyp> filteredTypen = new ArrayList<DoTyp>();
        filteredTypen.addAll(DarstellungExtensionPoint.getDoTypenWithExactMatch(systemObjectType));
        ObjektFactory factory = RahmenwerkService.getService().getObjektFactory();
        List systemObjekte = factory.bestimmeModellobjekte(new String[]{"typ.darstellungsObjektTyp"});
        for (SystemObjekt so : systemObjekte) {
            EditorDoTypReferenz doTyp = DoeditorFactory.eINSTANCE.createEditorDoTypReferenz();
            doTyp.setSystemObjekt(so);
            if (!systemObjectType.equals(doTyp.getSystemObjectType())) continue;
            filteredTypen.add(doTyp);
        }
        return filteredTypen;
    }

    public static Collection<DoTyp> getDoTypen(SystemObjectType systemObjectType) {
        if (systemObjectType == null) {
            throw new IllegalArgumentException("Argument darf nicht null sein.");
        }
        ArrayList<DoTyp> filteredTypen = new ArrayList<DoTyp>();
        filteredTypen.addAll(DarstellungExtensionPoint.getDoTypen(systemObjectType));
        ObjektFactory factory = RahmenwerkService.getService().getObjektFactory();
        List systemObjekte = factory.bestimmeModellobjekte(new String[]{"typ.darstellungsObjektTyp"});
        for (SystemObjekt so : systemObjekte) {
            EditorDoTypReferenz doTyp = DoeditorFactory.eINSTANCE.createEditorDoTypReferenz();
            doTyp.setSystemObjekt(so);
            if (!systemObjectType.equals(doTyp.getSystemObjectType()) && !systemObjectType.getSuperTypes().contains(doTyp.getSystemObjectType())) continue;
            filteredTypen.add(doTyp);
        }
        return filteredTypen;
    }

    public static ConfiguratedDoTyp getConfiguratedDoTyp(String extensionId) {
        return DarstellungExtensionPoint.getDoTyp(extensionId);
    }

    public static EditorDoTypReferenz getEditorDoTyp(String pid) {
        EditorDoTypReferenz doTyp = DoeditorFactory.eINSTANCE.createEditorDoTypReferenz();
        SystemObjekt so = RahmenwerkService.getService().getObjektFactory().getModellobjekt(pid);
        doTyp.setSystemObjekt(so);
        return doTyp;
    }
}

