/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.vektor;

import java.util.Objects;
import org.eclipse.draw2d.geometry.Point;

public class LineareFunktion {
    private final double m;
    private final double n;
    private final Point a;
    private final Point b;
    private final boolean yParallele;

    public LineareFunktion(Point a, Point b) {
        if (a.equals((Object)b)) {
            throw new IllegalArgumentException("Punkt a = " + String.valueOf(a) + " und Punkt b = " + String.valueOf(b) + " sind identisch.");
        }
        double xDif = a.preciseX() - b.preciseX();
        if (xDif == 0.0) {
            this.yParallele = true;
            this.m = a.preciseY() - b.preciseY() > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            this.n = Double.NaN;
        } else {
            this.yParallele = false;
            this.m = (a.preciseY() - b.preciseY()) / xDif;
            this.n = a.preciseY() - this.m * a.preciseX();
        }
        this.a = a;
        this.b = b;
    }

    public final double getFunktionsWert(double x) {
        return this.m * x + this.n;
    }

    public final double getAnstieg() {
        return this.m;
    }

    public final double getAbsolutglied() {
        return this.n;
    }

    public boolean isYParallele() {
        return this.yParallele;
    }

    public Point getStartPunkt() {
        return this.a;
    }

    public Point getEndPunkt() {
        return this.b;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LineareFunktion) {
            LineareFunktion that = (LineareFunktion)obj;
            if (this.yParallele || that.yParallele) {
                if (this.yParallele == that.yParallele) {
                    return this.a.equals((Object)that.a) && this.b.equals((Object)that.b);
                }
                return false;
            }
            return Double.compare(this.m, that.m) == 0 && Double.compare(this.n, that.n) == 0;
        }
        return false;
    }

    public String toString() {
        return "f(x) := " + (this.yParallele ? "Y-Parallele in x = " + this.a.x : this.m + "x " + (this.n >= 0.0 ? "+" : "-") + " " + Math.abs(this.n)) + " (von " + String.valueOf(this.a) + " nach " + String.valueOf(this.b) + ")";
    }

    public int hashCode() {
        return Objects.hash(this.a, this.b, this.m, this.n, this.yParallele);
    }
}

