/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dobj.vektor;

import java.util.Objects;
import org.eclipse.draw2d.geometry.Point;

public final class Vektor2D {
    public static final Vektor2D NULL_VEKTOR = new Vektor2D(0.0, 0.0);
    public final double x;
    public final double y;
    private Double laenge;
    private Vektor2D vektorNormiert;
    private Vektor2D normalenVektorR;
    private Vektor2D normalenVektorL;

    private Vektor2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vektor2D(Point a, Point b) {
        this.x = b.preciseX() - a.preciseX();
        this.y = b.preciseY() - a.preciseY();
    }

    public Double getLaenge() {
        if (this.laenge == null) {
            this.laenge = Math.sqrt(this.x * this.x + this.y * this.y);
        }
        return this.laenge;
    }

    public Vektor2D getVektorNormiert() {
        if (this.vektorNormiert == null) {
            if (this.getLaenge() == 0.0) {
                return NULL_VEKTOR;
            }
            this.vektorNormiert = new Vektor2D(this.x / this.getLaenge(), this.y / this.getLaenge());
        }
        return this.vektorNormiert;
    }

    public Vektor2D getNormalenVektorRechts() {
        if (this.normalenVektorR == null) {
            this.normalenVektorR = new Vektor2D(-this.y, this.x);
        }
        return this.normalenVektorR;
    }

    public Vektor2D getNormalenVektorLinks() {
        if (this.normalenVektorL == null) {
            this.normalenVektorL = new Vektor2D(this.y, -this.x);
        }
        return this.normalenVektorL;
    }

    public Vektor2D getVektorSkaliert(double skalierung) {
        return new Vektor2D(this.x * skalierung, this.y * skalierung);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Vektor2D other = (Vektor2D)obj;
        return Double.doubleToLongBits(this.x) == Double.doubleToLongBits(other.x) && Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

