/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.actions;

import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungIcons;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class EditEbeneAction
extends Action
implements ISelectionChangedListener {
    private final EditPartViewer viewer;

    public EditEbeneAction(EditPartViewer viewer) {
        this.setText("Ebene bearbeiten");
        this.setImageDescriptor(DarstellungIcons.ActionEditEbene.getImageDescriptor());
        this.setToolTipText("Versetzt die ausgew\u00e4hlte Ebene in den Bearbeitungsmodus und alle anderen in den normalen Modus.");
        this.viewer = viewer;
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void run() {
        Ebene current = this.getSelection();
        EObject root = EcoreUtil.getRootContainer((EObject)current);
        TreeIterator allContents = EcoreUtil.getAllContents((EObject)root, (boolean)true);
        allContents.forEachRemaining(obj -> {
            if (obj instanceof Ebene) {
                Ebene ebene2 = (Ebene)obj;
                if (current.equals(ebene2)) {
                    ebene2.setEditable(true);
                } else {
                    ebene2.setEditable(false);
                }
            }
        });
    }

    private Ebene getSelection() {
        List editParts = this.viewer.getSelectedEditParts();
        if (!editParts.isEmpty() && ((EditPart)editParts.get(0)).getModel() instanceof Ebene) {
            return (Ebene)((EditPart)editParts.get(0)).getModel();
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setEnabled(this.getSelection() != null);
    }
}

