/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.actions;

import de.bsvrz.buv.plugin.darstellung.actions.DarstellungStatus;
import de.bsvrz.buv.plugin.darstellung.editparts.AnsichtEditPart;
import de.bsvrz.buv.plugin.darstellung.editparts.DarstellungEditPart;
import de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung;
import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.util.Projektion;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktXY;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.ui.IWorkbenchPage;

public class PositionStatus
extends DarstellungStatus
implements MouseMoveListener,
ISelectionChangedListener {
    private static final NumberFormat FORMATER = new DecimalFormat("###.######");
    private Point mouseLocation;
    private Point primaryLocation;

    static {
        FORMATER.setMinimumFractionDigits(6);
        FORMATER.setMaximumFractionDigits(6);
    }

    public PositionStatus(IWorkbenchPage page) {
        super(page, PositionStatus.class.toString(), 35);
    }

    @Override
    protected void activate() {
        this.getViewer().getControl().addMouseMoveListener((MouseMoveListener)this);
        this.getViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    @Override
    protected void deactivate() {
        this.getViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.getViewer().getControl().removeMouseMoveListener((MouseMoveListener)this);
    }

    public void mouseMove(MouseEvent e) {
        if (this.getZoomManager() == null) {
            return;
        }
        int offset = this.getZoomManager().getViewport().getHorizontalRangeModel().getValue();
        double x = (double)(offset + e.x) / this.getZoomManager().getZoom();
        offset = this.getZoomManager().getViewport().getVerticalRangeModel().getValue();
        double y = (double)(offset + e.y) / this.getZoomManager().getZoom();
        this.mouseLocation = new Point((int)x, (int)y);
        this.updateAnzeige();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        EditPart primSel;
        this.primaryLocation = null;
        if (event.getSelection() instanceof StructuredSelection && (primSel = PositionStatus.getPrimarySelectionOf((StructuredSelection)event.getSelection())) != null) {
            this.primaryLocation = this.getLocationOf(primSel);
            if (this.primaryLocation == null && !(primSel instanceof AnsichtEditPart) && !(primSel instanceof DarstellungEditPart)) {
                this.primaryLocation = this.mouseLocation;
            }
        }
        this.updateAnzeige();
    }

    private void updateAnzeige() {
        if (this.getViewer() != null && this.getViewer().getProperty(Projektion.class.toString()) != null) {
            Projektion projektion = (Projektion)this.getViewer().getProperty(Projektion.class.toString());
            Object text = "";
            if (this.primaryLocation != null) {
                if (this.getDarstellung() instanceof MassstaeblicheDarstellung) {
                    text = this.primaryLocation instanceof PrecisionPoint ? PositionStatus.getWGSString(this.primaryLocation) : PositionStatus.getWGSString(projektion.umrechnenModellNachWelt(this.primaryLocation));
                } else {
                    NumberFormat formatter = NumberFormat.getIntegerInstance();
                    text = formatter.format(this.primaryLocation.x) + ", " + formatter.format(this.primaryLocation.y);
                }
            } else if (this.mouseLocation != null) {
                if (this.getDarstellung() instanceof MassstaeblicheDarstellung) {
                    text = PositionStatus.getWGSString(projektion.umrechnenModellNachWelt(this.mouseLocation));
                } else {
                    NumberFormat formatter = NumberFormat.getIntegerInstance();
                    text = formatter.format(this.mouseLocation.x) + ", " + formatter.format(this.mouseLocation.y);
                }
            }
            this.setText((String)text);
        }
    }

    private static String getWGSString(Point wgsPoint) {
        Object wgsString = "";
        wgsString = wgsPoint.preciseY() < 0.0 ? FORMATER.format(Math.abs(wgsPoint.preciseY())) + "\u00b0 S" : FORMATER.format(wgsPoint.preciseY()) + "\u00b0 N";
        wgsString = (String)wgsString + " / ";
        wgsString = wgsPoint.preciseX() < 0.0 ? (String)wgsString + FORMATER.format(Math.abs(wgsPoint.preciseX())) + "\u00b0 W" : (String)wgsString + FORMATER.format(wgsPoint.preciseX()) + "\u00b0 O";
        return wgsString;
    }

    private Point getLocationOf(EditPart ep) {
        if (ep != null && !(ep instanceof AnsichtEditPart) && ep.getModel() instanceof DoModel) {
            PrecisionPoint editPartLocation;
            DoModel dom = (DoModel)ep.getModel();
            if (this.getDarstellung() instanceof MassstaeblicheDarstellung && (editPartLocation = PositionStatus.getSystemObjectLocation(dom.getSystemObject())) != null) {
                return editPartLocation;
            }
            return dom.getLocation();
        }
        return null;
    }

    private static PrecisionPoint getSystemObjectLocation(SystemObject sysObj) {
        PunktXY punkt;
        KdPunktKoordinaten.Daten daten;
        ObjektFactory of;
        SystemObjekt bcSysObj;
        PrecisionPoint location = null;
        if (sysObj != null && (bcSysObj = (of = RahmenwerkService.getService().getObjektFactory()).getModellobjekt(sysObj.getPid())) != null && bcSysObj instanceof PunktXY && (daten = (KdPunktKoordinaten.Daten)(punkt = (PunktXY)bcSysObj).getKdPunktKoordinaten().getDatum()) != null && daten.getX() != null && daten.getY() != null) {
            location = new PrecisionPoint(daten.getX().doubleValue(), daten.getY().doubleValue());
        }
        return location;
    }

    private static EditPart getPrimarySelectionOf(StructuredSelection sel) {
        EditPart primarySelectedEditPart = null;
        if (!sel.isEmpty()) {
            Object[] objectArray = sel.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                EditPart ep;
                Object element = objectArray[n2];
                if (element instanceof EditPart && (ep = (EditPart)element).getSelected() == 2) {
                    primarySelectedEditPart = ep;
                    break;
                }
                ++n2;
            }
        }
        return primarySelectedEditPart;
    }
}

