/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.actions;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipsePackage;
import com.bitctrl.lib.eclipse.emf.gef.commands.AddCommand;
import com.bitctrl.lib.eclipse.emf.gef.commands.RemoveCommand;
import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import de.bsvrz.buv.plugin.darstellung.actions.DarstellungActionFactory;
import de.bsvrz.buv.plugin.darstellung.dialogs.AusschnittAnlegenDialog;
import de.bsvrz.buv.plugin.darstellung.dialogs.AusschnitteVerwaltenDialog;
import de.bsvrz.buv.plugin.darstellung.editparts.AnsichtEditPart;
import de.bsvrz.buv.plugin.darstellung.internal.DarstellungMessages;
import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.Ausschnitt;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungFactory;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungIcons;
import de.bsvrz.buv.plugin.dobj.actions.DobjWorkbenchPartAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPart;

public class SelectAusschnittAction
extends DobjWorkbenchPartAction
implements IMenuCreator {
    private Menu menu;

    public SelectAusschnittAction(IWorkbenchPart part) {
        super(part, 4);
        this.setText(DarstellungMessages.SelectAusschnitt_Label);
        this.setImageDescriptor(DarstellungIcons.ActionSelectAusschnitt.getImageDescriptor());
        this.setToolTipText(DarstellungMessages.SelectAusschnitt_Tooltip);
        this.setId(DarstellungActionFactory.SELECT_AUSSCHNITT.getCommandId());
        this.setActionDefinitionId(DarstellungActionFactory.SELECT_AUSSCHNITT.getCommandId());
    }

    public IMenuCreator getMenuCreator() {
        return this;
    }

    public void run() {
        new AusschnittSichernAction(this.getAnsicht()).run();
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
        }
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        Ansicht ansicht = this.getAnsicht();
        this.menu = new Menu(parent);
        if (ansicht != null) {
            this.addActionToMenu(this.menu, new AusschnittSichernAction(ansicht));
            this.addActionToMenu(this.menu, new AusschnitteVerwaltenAction(ansicht));
            new MenuItem(this.menu, 2);
            this.addActionToMenu(this.menu, new DefaultAnsichtAction(ansicht));
            for (Ausschnitt ausschnitt : ansicht.getAusschnitte()) {
                this.addActionToMenu(this.menu, new AusschnittAnzeigenAction(ansicht, ausschnitt));
            }
        }
        return this.menu;
    }

    private Ansicht getAnsicht() {
        Object ansicht;
        EditPart content = this.getViewer().getContents();
        if (content instanceof AnsichtEditPart && (ansicht = content.getModel()) instanceof Ansicht) {
            return (Ansicht)ansicht;
        }
        return null;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    private class AusschnittAnzeigenAction
    extends Action {
        private final Ansicht ansicht;
        private final Ausschnitt ausschnitt;

        AusschnittAnzeigenAction(Ansicht ansicht, Ausschnitt ausschnitt) {
            super(ausschnitt.getName());
            this.ansicht = ansicht;
            this.ausschnitt = ausschnitt;
            if (ausschnitt.equals(ansicht.getAusschnitt())) {
                this.setText(ausschnitt.getName() + " (Standardausschnitt)");
            }
        }

        public boolean isEnabled() {
            return this.ausschnitt != null && this.ansicht != null;
        }

        public void run() {
            if (this.isEnabled()) {
                SelectAusschnittAction.this.getZoomManager().setZoom(this.ausschnitt.getZoomLevel());
                SelectAusschnittAction.this.getZoomManager().getViewport().setHorizontalLocation(this.ausschnitt.getBounds().x);
                SelectAusschnittAction.this.getZoomManager().getViewport().setVerticalLocation(this.ausschnitt.getBounds().y);
            }
        }
    }

    private class AusschnittSichernAction
    extends Action {
        private final Ansicht ansicht;

        AusschnittSichernAction(Ansicht ansicht) {
            super("Aktuellen Ausschnitt sichern");
            this.ansicht = ansicht;
        }

        public boolean isEnabled() {
            return this.ansicht != null;
        }

        public void run() {
            AusschnittAnlegenDialog dialog;
            if (this.isEnabled() && (dialog = new AusschnittAnlegenDialog(this.ansicht)).open() == 0) {
                Rectangle clientArea = SelectAusschnittAction.this.getZoomManager().getViewport().getClientArea();
                double zoom = SelectAusschnittAction.this.getZoomManager().getZoom();
                String name = dialog.getValue();
                Ausschnitt ausschnitt = null;
                for (Ausschnitt item : this.ansicht.getAusschnitte()) {
                    if (!item.getName().equals(name)) continue;
                    ausschnitt = item;
                    break;
                }
                if (ausschnitt == null) {
                    ausschnitt = DarstellungFactory.eINSTANCE.createAusschnitt();
                    ausschnitt.setZoomLevel(zoom);
                    ausschnitt.setBounds(clientArea);
                    ausschnitt.setName(name);
                    command = new AddCommand((EObject)this.ansicht, (EStructuralFeature)DarstellungPackage.Literals.ANSICHT__AUSSCHNITTE, (Object)ausschnitt);
                    SelectAusschnittAction.this.getCommandStack().execute((Command)command);
                } else {
                    command = new SetCommand((EObject)ausschnitt, (EStructuralFeature)DarstellungPackage.Literals.AUSSCHNITT__BOUNDS, (Object)clientArea);
                    SelectAusschnittAction.this.getCommandStack().execute((Command)command);
                    command = new SetCommand((EObject)ausschnitt, (EStructuralFeature)DarstellungPackage.Literals.AUSSCHNITT__ZOOM_LEVEL, (Object)zoom);
                    SelectAusschnittAction.this.getCommandStack().execute((Command)command);
                }
            }
        }
    }

    private class AusschnitteVerwaltenAction
    extends Action {
        private final Ansicht ansicht;

        AusschnitteVerwaltenAction(Ansicht ansicht) {
            super("Ausschnitte verwalten");
            this.ansicht = ansicht;
        }

        public boolean isEnabled() {
            return this.ansicht != null && !this.ansicht.getAusschnitte().isEmpty();
        }

        public void run() {
            AusschnitteVerwaltenDialog dialog = new AusschnitteVerwaltenDialog(SelectAusschnittAction.this.getWorkbenchPart().getSite().getShell(), this.ansicht);
            if (dialog.open() == 0) {
                Map<Ausschnitt, String> result = dialog.getResult();
                ArrayList<Ausschnitt> original = new ArrayList<Ausschnitt>((Collection<Ausschnitt>)this.ansicht.getAusschnitte());
                SetCommand defaultCommand = new SetCommand((EObject)this.ansicht, (EStructuralFeature)DarstellungPackage.Literals.ANSICHT__AUSSCHNITT, (Object)dialog.getDefaultAusschnitt());
                SelectAusschnittAction.this.getCommandStack().execute((Command)defaultCommand);
                for (Ausschnitt ausschnitt : original) {
                    if (!result.containsKey(ausschnitt)) {
                        RemoveCommand command = new RemoveCommand((EObject)this.ansicht, (EStructuralFeature)DarstellungPackage.Literals.ANSICHT__AUSSCHNITTE, (Object)ausschnitt);
                        SelectAusschnittAction.this.getCommandStack().execute((Command)command);
                        continue;
                    }
                    String name = result.get(ausschnitt);
                    if (ausschnitt.getName().equals(name)) continue;
                    SetCommand command = new SetCommand((EObject)ausschnitt, (EStructuralFeature)EclipsePackage.Literals.NAMED__NAME, (Object)name);
                    SelectAusschnittAction.this.getCommandStack().execute((Command)command);
                }
            }
        }
    }

    private class DefaultAnsichtAction
    extends Action {
        private final Ansicht ansicht;

        DefaultAnsichtAction(Ansicht ansicht) {
            super("Gesamtansicht anzeigen");
            this.ansicht = ansicht;
        }

        public boolean isEnabled() {
            return this.ansicht != null;
        }

        public void run() {
            if (this.isEnabled()) {
                SelectAusschnittAction.this.getZoomManager().setZoom(1.0 / SelectAusschnittAction.this.getZoomManager().getUIMultiplier());
                SelectAusschnittAction.this.getZoomManager().getViewport().setHorizontalLocation(0);
                SelectAusschnittAction.this.getZoomManager().getViewport().setVerticalLocation(0);
            }
        }
    }
}

