/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.actions;

import com.bitctrl.lib.eclipse.emf.util.EmfUtil;
import de.bsvrz.buv.plugin.darstellung.actions.DarstellungStatus;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbenchPage;

public class SelectionStatus
extends DarstellungStatus
implements ISelectionChangedListener {
    public SelectionStatus(IWorkbenchPage page) {
        super(page, SelectionStatus.class.toString(), 50);
    }

    @Override
    protected void activate() {
        this.getViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    @Override
    protected void deactivate() {
        this.getViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            this.setText("Kein Objekt ausgew\u00e4hlt");
            return;
        }
        Object model = SelectionStatus.getPrimarySelectionOrFirstElement((IStructuredSelection)selection);
        if (model instanceof DoModel) {
            this.setText(SelectionStatus.getSystemObjektBezeichnerOderDarstellungsObjektName((DoModel)model));
        } else {
            this.setText(SelectionStatus.getText(model));
        }
    }

    private static Object getPrimarySelectionOrFirstElement(IStructuredSelection selection) {
        for (Object e : selection.toList()) {
            EditPart editPart = (EditPart)e;
            if (editPart.getSelected() != 2) continue;
            return editPart.getModel();
        }
        EditPart firstElement = (EditPart)selection.getFirstElement();
        return firstElement.getModel();
    }

    private static String getSystemObjektBezeichnerOderDarstellungsObjektName(DoModel model) {
        SystemObject so = model.getSystemObject();
        String name = model.getName();
        if (so != null) {
            if (so.getName() != null) {
                return so.getName();
            }
            return so.getPid();
        }
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return EmfUtil.getText((EObject)model);
    }

    private static String getText(Object model) {
        if (model instanceof EObject) {
            return EmfUtil.getText((EObject)((EObject)model));
        }
        return model.toString();
    }
}

