/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungAdapter;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;

public class AddDoModelToDarstellungsSpalteCommand
extends Command {
    private final DoModel model;
    private final DarstellungsSpalte darstellungsSpalte;
    private final Point location;
    private Point oldLocation;
    private DarstellungsSpalte oldDarstellungsSpalte;
    private int oldDarstellungsSpalteIndex;

    public AddDoModelToDarstellungsSpalteCommand(DoModel model, Point location, DarstellungsSpalte darstellungsSpalte) {
        Assert.isNotNull((Object)model, (String)"model");
        Assert.isLegal((boolean)(model.eContainer() instanceof Ebene), (String)"model muss in einer Ebene liegen");
        Assert.isNotNull((Object)location, (String)"location");
        Assert.isNotNull((Object)darstellungsSpalte, (String)"darstellungsSpalte");
        this.model = model;
        this.location = location;
        this.darstellungsSpalte = darstellungsSpalte;
        this.setLabel("Objekt auf andere Darstellungsspalte verschieben");
    }

    public void execute() {
        this.oldLocation = this.model.getLocation();
        this.oldDarstellungsSpalte = this.getOldDarstellungsSpalte();
        this.oldDarstellungsSpalteIndex = this.oldDarstellungsSpalte.getDoObjekte().indexOf((Object)this.model);
        this.redo();
    }

    private DarstellungsSpalte getOldDarstellungsSpalte() {
        Ebene ebene = (Ebene)this.model.eContainer();
        StilisierteDarstellung darstellung = (StilisierteDarstellung)DarstellungAdapter.getDarstellung((EObject)ebene);
        for (DarstellungsSpalte e : darstellung.getSpalten()) {
            if (!e.getDoObjekte().contains((Object)this.model)) continue;
            return e;
        }
        throw new IllegalStateException("model muss in einer Darstellungsspalte liegen");
    }

    public void redo() {
        this.model.setLocation(this.location);
        this.oldDarstellungsSpalte.getDoObjekte().remove(this.oldDarstellungsSpalteIndex);
        this.darstellungsSpalte.getDoObjekte().add((Object)this.model);
    }

    public void undo() {
        this.darstellungsSpalte.getDoObjekte().remove((Object)this.model);
        this.oldDarstellungsSpalte.getDoObjekte().add(this.oldDarstellungsSpalteIndex, (Object)this.model);
        this.model.setLocation(this.oldLocation);
    }
}

