/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.dobj.model.DoKompositum;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;

public class AddDoModelToEbeneCommand
extends Command {
    private final Ebene ebene;
    private final DoModel model;
    private EObject oldEbene;
    private int indexInOldEbene;

    public AddDoModelToEbeneCommand(DoModel model, Ebene ebene) {
        Assert.isNotNull((Object)model, (String)"model");
        Assert.isLegal((model.eContainer() != null ? 1 : 0) != 0, (String)"model muss in einer Ebene oder einem Container liegen");
        Assert.isNotNull((Object)ebene, (String)"ebene");
        this.model = model;
        this.ebene = ebene;
        this.setLabel("Darstellungsobjekt auf andere Ebene verschieben");
    }

    public void execute() {
        this.oldEbene = this.model.eContainer();
        EObject eObject = this.oldEbene;
        if (eObject instanceof Ebene) {
            Ebene ebene = (Ebene)eObject;
            this.indexInOldEbene = ebene.getDoObjekte().indexOf((Object)this.model);
        } else if (this.oldEbene instanceof DoKompositum) {
            this.indexInOldEbene = ((DoKompositum)this.oldEbene).getKomponenten().indexOf((Object)this.model);
        } else {
            throw new IllegalArgumentException("Das DoObjekt muss sich in einer Ebene oder einem Kompositum befinden.");
        }
        this.redo();
    }

    public void redo() {
        this.ebene.getDoObjekte().add((Object)this.model);
    }

    public void undo() {
        EObject eObject = this.oldEbene;
        if (eObject instanceof Ebene) {
            Ebene ebene = (Ebene)eObject;
            ebene.getDoObjekte().add(this.indexInOldEbene, (Object)this.model);
        } else if (this.oldEbene instanceof DoKompositum) {
            ((DoKompositum)this.oldEbene).getKomponenten().add(this.indexInOldEbene, (Object)this.model);
        }
    }
}

