/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;

public class AddEbeneToDarstellungCommand
extends Command {
    private final Darstellung destination;
    private final Ebene model;
    private EObject oldContainer;
    private int indexInOldEbene;

    public AddEbeneToDarstellungCommand(Ebene model, Darstellung destination) {
        Assert.isNotNull((Object)model, (String)"model");
        Assert.isLegal((model.eContainer() instanceof Ebene || model.eContainer() instanceof Darstellung ? 1 : 0) != 0, (String)"model muss in einer Ebene oder Darstellung liegen");
        Assert.isNotNull((Object)destination, (String)"dartellung");
        this.model = model;
        this.destination = destination;
        this.setLabel("Ebene in die Wurzel der Darstellung verschieben");
    }

    public void execute() {
        this.oldContainer = this.model.eContainer();
        EObject eObject = this.oldContainer;
        if (eObject instanceof Ebene) {
            Ebene ebene = (Ebene)eObject;
            this.indexInOldEbene = ebene.getEbenen().indexOf((Object)this.model);
        } else {
            EObject eObject2 = this.oldContainer;
            if (eObject2 instanceof Darstellung) {
                Darstellung darstellung = (Darstellung)eObject2;
                this.indexInOldEbene = darstellung.getEbenen().indexOf((Object)this.model);
            }
        }
        this.redo();
    }

    public void redo() {
        this.destination.getEbenen().add((Object)this.model);
    }

    public void undo() {
        EObject eObject = this.oldContainer;
        if (eObject instanceof Ebene) {
            Ebene ebene = (Ebene)eObject;
            ebene.getEbenen().add(this.indexInOldEbene, (Object)this.model);
        } else {
            EObject eObject2 = this.oldContainer;
            if (eObject2 instanceof Darstellung) {
                Darstellung darstellung = (Darstellung)eObject2;
                darstellung.getEbenen().add(this.indexInOldEbene, (Object)this.model);
            }
        }
    }
}

