/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;

public class AddEbeneToEbeneCommand
extends Command {
    private final Ebene destination;
    private final Ebene model;
    private EObject oldContainer;
    private int indexInOldEbene;

    public AddEbeneToEbeneCommand(Ebene model, Ebene destination) {
        Assert.isNotNull((Object)model, (String)"model");
        Assert.isLegal((model.eContainer() instanceof Ebene || model.eContainer() instanceof Darstellung ? 1 : 0) != 0, (String)"model muss in einer Ebene oder Darstellung liegen");
        Assert.isNotNull((Object)destination, (String)"ebene");
        this.model = model;
        this.destination = destination;
        this.setLabel("Ebene auf andere Ebene verschieben");
    }

    public void execute() {
        this.oldContainer = this.model.eContainer();
        if (this.oldContainer instanceof Ebene) {
            this.indexInOldEbene = ((Ebene)this.oldContainer).getEbenen().indexOf((Object)this.model);
        } else if (this.oldContainer instanceof Darstellung) {
            this.indexInOldEbene = ((Darstellung)this.oldContainer).getEbenen().indexOf((Object)this.model);
        }
        this.redo();
    }

    public void redo() {
        this.destination.getEbenen().add((Object)this.model);
    }

    public void undo() {
        if (this.oldContainer instanceof Ebene) {
            ((Ebene)this.oldContainer).getEbenen().add(this.indexInOldEbene, (Object)this.model);
        } else if (this.oldContainer instanceof Darstellung) {
            ((Darstellung)this.oldContainer).getEbenen().add(this.indexInOldEbene, (Object)this.model);
        }
    }
}

