/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.commands.Command;

public class ChangeIndexOfDoModelCommand
extends Command {
    private final Ebene ebene;
    private final int newIndexInEbene;
    private final int oldIndexInEbene;

    public ChangeIndexOfDoModelCommand(DoModel model, Ebene ebene, int newIndex) {
        Assert.isNotNull((Object)model, (String)"model");
        Assert.isNotNull((Object)ebene, (String)"ebene");
        this.ebene = ebene;
        this.oldIndexInEbene = ebene.getDoObjekte().indexOf((Object)model);
        this.newIndexInEbene = newIndex > this.oldIndexInEbene ? newIndex - 1 : newIndex;
    }

    public boolean canExecute() {
        return this.oldIndexInEbene != this.newIndexInEbene && this.newIndexInEbene >= 0 && this.newIndexInEbene < this.ebene.getDoObjekte().size();
    }

    public void execute() {
        Assert.isTrue((boolean)this.canExecute(), (String)"command is not executable");
        this.redo();
    }

    public void redo() {
        this.ebene.getDoObjekte().move(this.newIndexInEbene, this.oldIndexInEbene);
    }

    public void undo() {
        this.ebene.getDoObjekte().move(this.oldIndexInEbene, this.newIndexInEbene);
    }
}

