/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import de.bsvrz.buv.plugin.darstellung.model.AutoEbene;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.dobj.model.ConfiguratedDoTyp;
import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.model.DoKompositum;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoTypReferenz;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class CommandUtil {
    static boolean contains(Collection<DoTyp> doTypen, DoTyp doTyp) {
        return CommandUtil.getDoTyp(doTypen, doTyp) != null;
    }

    static DoTyp getDoTyp(Collection<DoTyp> doTypen, DoTyp doTyp) {
        block3: {
            block2: {
                if (!(doTyp instanceof ConfiguratedDoTyp)) break block2;
                ConfiguratedDoTyp modelDot = (ConfiguratedDoTyp)doTyp;
                for (DoTyp dot : doTypen) {
                    if (!(dot instanceof ConfiguratedDoTyp)) continue;
                    ConfiguratedDoTyp darstellungDot = (ConfiguratedDoTyp)dot;
                    if (!modelDot.getId().equals(darstellungDot.getId())) continue;
                    return darstellungDot;
                }
                break block3;
            }
            if (!(doTyp instanceof EditorDoTypReferenz)) break block3;
            EditorDoTypReferenz modelDot = (EditorDoTypReferenz)doTyp;
            for (DoTyp dot : doTypen) {
                if (!(dot instanceof EditorDoTypReferenz)) continue;
                EditorDoTypReferenz darstellungDot = (EditorDoTypReferenz)dot;
                if (!modelDot.getSystemObjekt().equals(darstellungDot.getSystemObjekt())) continue;
                return darstellungDot;
            }
        }
        return null;
    }

    static boolean isUsedDoTypInDarstellung(DoTyp doTyp, Darstellung darstellung, AutoEbene excludeEbene) {
        return CommandUtil.isUsedDoTypInDarstellung(doTyp, darstellung, new ArrayList<DoModel>(), excludeEbene);
    }

    private static boolean isUsedDoTypInDarstellung(DoTyp doTyp, Darstellung darstellung, Collection<DoModel> excludes, AutoEbene excludeEbene) {
        TreeIterator allContents = EcoreUtil.getAllContents((EObject)darstellung, (boolean)true);
        while (allContents.hasNext()) {
            EObject next = (EObject)allContents.next();
            if (!(next instanceof Ebene)) continue;
            Ebene ebene = (Ebene)next;
            if (ebene instanceof AutoEbene) {
                AutoEbene autoEbene = (AutoEbene)ebene;
                if (ebene != excludeEbene) {
                    for (DoTyp dot : autoEbene.getDoTypen()) {
                        if (!Objects.equals(dot.getId(), doTyp.getId())) continue;
                        return true;
                    }
                }
            }
            for (DoModel model : ebene.getDoObjekte()) {
                DoKompositum kompositum;
                if (excludes.contains(model)) continue;
                if (model.getDoTyp().getId() == doTyp.getId()) {
                    return true;
                }
                if (!(model instanceof DoKompositum) || !CommandUtil.isUsedDoTypInKompositum(doTyp, kompositum = (DoKompositum)((Object)model), excludes)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isUsedDoTypInKompositum(DoTyp doTyp, DoKompositum<DoModel> kompositum, Collection<DoModel> excludes) {
        for (DoKomponente komponente : kompositum.getKomponenten()) {
            DoKompositum k;
            DoModel model;
            if (!(komponente instanceof DoModel) || excludes.contains(model = (DoModel)komponente)) continue;
            if (model.getDoTyp() == doTyp) {
                return true;
            }
            if (!(model instanceof DoKompositum) || !CommandUtil.isUsedDoTypInKompositum(doTyp, k = (DoKompositum)((Object)model), excludes)) continue;
            return true;
        }
        return false;
    }

    private CommandUtil() {
    }
}

