/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import com.bitctrl.lib.eclipse.emf.gef.model.Sized;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungAdapter;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;

public class CreateDoModelCommand
extends Command {
    private final DoModel model;
    private final Ebene ebene;
    private final DarstellungsSpalte darstellungsSpalte;
    private Point location;
    private Dimension size;

    public CreateDoModelCommand(DoModel model, Ebene ebene) {
        this(model, ebene, null);
    }

    public CreateDoModelCommand(DoModel model, Ebene ebene, DarstellungsSpalte darstellungsSpalte) {
        Assert.isNotNull((Object)model, (String)"model");
        Assert.isNotNull((Object)ebene, (String)"ebene");
        this.assertDarstellungsSpalteNeeded(ebene, darstellungsSpalte);
        this.model = model;
        this.ebene = ebene;
        this.darstellungsSpalte = darstellungsSpalte;
        this.setLabel("Darstellungsonjekt anlegen");
    }

    private void assertDarstellungsSpalteNeeded(Ebene e, DarstellungsSpalte s) {
        StilisierteDarstellung stilisierteDarstellung;
        Darstellung darstellung = DarstellungAdapter.getDarstellung((EObject)e);
        if (darstellung instanceof StilisierteDarstellung && !(stilisierteDarstellung = (StilisierteDarstellung)darstellung).getSpalten().isEmpty()) {
            Assert.isNotNull((Object)s, (String)"darstellungsSpalte");
        }
    }

    public Point getLocation() {
        return this.location;
    }

    public void setLocation(Point location) {
        this.location = location;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public boolean canExecute() {
        return this.location != null || this.model.getLocation() != null;
    }

    public void execute() {
        Assert.isTrue((boolean)this.canExecute(), (String)"command is not executable");
        this.applyConstraintsIfNecessary();
        this.redo();
    }

    private void applyConstraintsIfNecessary() {
        if (this.getLocation() != null) {
            this.model.setLocation(this.getLocation());
        } else {
            Assert.isNotNull((Object)this.model.getLocation(), (String)"entweder constraint oder location muss gesetzt sein");
        }
        if (this.model instanceof Sized && this.getSize() != null) {
            ((Sized)this.model).setSize(this.getSize());
        }
    }

    public void redo() {
        this.ebene.getDoObjekte().add((Object)this.model);
        if (this.darstellungsSpalte != null) {
            this.darstellungsSpalte.getDoObjekte().add((Object)this.model);
        }
    }

    public void undo() {
        if (this.darstellungsSpalte != null) {
            this.darstellungsSpalte.getDoObjekte().remove((Object)this.model);
        }
        this.ebene.getDoObjekte().remove((Object)this.model);
    }
}

